/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.Utils;

public class ASN1Date
implements ASN1TaggedObject {
    private ASN1Header a;
    private Date b;
    private boolean c;

    public ASN1Date() {
        this(new Date());
    }

    public ASN1Date(Date date) {
        this(date, false);
    }

    public ASN1Date(Date date, boolean bl) {
        this.a(date, bl);
    }

    public ASN1Date(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(Date date, boolean bl) {
        this.b = date;
        this.c = bl;
        this.a = new ASN1Header(bl ? 24 : 23, 0, 0, bl ? 15 : 13);
    }

    @Override
    public ASN1Header a() {
        return this.a;
    }

    public Date b() {
        return this.b;
    }

    public void a(boolean bl) {
        this.c = bl;
    }

    public boolean c() {
        return this.c;
    }

    public String toString() {
        return (this.c ? "GeneralizedTime " : "UTCTime ") + this.b.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = Utils.inputByte(pushbackInputStream) & 0xFF;
        pushbackInputStream.unread(n);
        int n2 = ASN1Utils.d(n);
        this.a(ASN1Date.a(pushbackInputStream), n2 == 24);
    }

    public static Date a(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.d(0);
        int n = aSN1Header.a();
        if (n != 23 && n != 24) {
            throw new ASN1FormatException("Got tag " + n + " instead of " + 23 + " or " + 24 + ".");
        }
        return Utils.parseDate(Utils.fromUTF8(ASN1Date.a(inputStream, aSN1Header, 0)), n == 24);
    }

    private static byte[] a(InputStream inputStream, ASN1Header aSN1Header, int n) throws IOException {
        if (aSN1Header == null) {
            aSN1Header = new ASN1Header(inputStream);
            aSN1Header.d(0);
            aSN1Header.e(n);
        }
        if (aSN1Header.c() == 0) {
            return aSN1Header.d(inputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.a()) {
            byteArrayOutputStream.write(ASN1Date.a(aSN1ConstructedInputStream, null, n));
        }
        aSN1ConstructedInputStream.b();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        ASN1Date.b(outputStream, this.b, this.c);
    }

    @Override
    public int length() {
        return this.a.g();
    }

    public static void a(OutputStream outputStream, Date date) throws IOException {
        ASN1Date.a(outputStream, date, false);
    }

    public static void a(OutputStream outputStream, Date date, boolean bl) throws IOException {
        ASN1Date.a(outputStream, date, bl, bl ? 24 : 23, 0);
    }

    public static void a(OutputStream outputStream, Date date, int n) throws IOException {
        ASN1Date.a(outputStream, date, false, n);
    }

    public static void a(OutputStream outputStream, Date date, boolean bl, int n) throws IOException {
        ASN1Date.a(outputStream, date, bl, n, 128);
    }

    private static void a(OutputStream outputStream, Date date, boolean bl, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        outputStream.write(bl ? 15 : 13);
        ASN1Date.b(outputStream, date, bl);
    }

    private static void b(OutputStream outputStream, Date date, boolean bl) throws IOException {
        outputStream.write(Utils.toUTF8(Utils.formatDate(date, bl)));
    }
}

