/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.opensearch.action.support.broadcast.BroadcastShardRequest;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.internal.AliasFilter;

public class ShardValidateQueryRequest
extends BroadcastShardRequest {
    private QueryBuilder query;
    private boolean explain;
    private boolean rewrite;
    private long nowInMillis;
    private AliasFilter filteringAliases;

    public ShardValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        int typesSize;
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        if (in.getVersion().before(Version.V_2_0_0) && (typesSize = in.readVInt()) > 0) {
            for (int i = 0; i < typesSize; ++i) {
                in.readString();
            }
        }
        this.filteringAliases = new AliasFilter(in);
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.nowInMillis = in.readVLong();
    }

    public ShardValidateQueryRequest(ShardId shardId, AliasFilter filteringAliases, ValidateQueryRequest request) {
        super(shardId, request);
        this.query = request.query();
        this.explain = request.explain();
        this.rewrite = request.rewrite();
        this.filteringAliases = Objects.requireNonNull(filteringAliases, "filteringAliases must not be null");
        this.nowInMillis = request.nowInMillis;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public AliasFilter filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeVInt(0);
        }
        this.filteringAliases.writeTo(out);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeVLong(this.nowInMillis);
    }
}

