/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\n\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u001c\u0010\u000f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u001c\u0010\u0012\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\r\u00a8\u0006\u0014"}, d2={"getBucketKeysHash", "", "bucketKeys", "", "Lorg/opensearch/commons/alerting/model/AggregationResultBucket;", "instant", "Ljava/time/Instant;", "Lorg/opensearch/core/xcontent/XContentParser;", "isBucketLevelMonitor", "", "Lorg/opensearch/commons/alerting/model/Monitor;", "isMonitorOfStandardType", "optionalTimeField", "Lorg/opensearch/core/xcontent/XContentBuilder;", "name", "optionalUserField", "user", "Lorg/opensearch/commons/authuser/User;", "optionalUsernameField", "string", "common-utils"})
@SourceDebugExtension(value={"SMAP\nIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexUtils.kt\norg/opensearch/commons/alerting/util/IndexUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n11065#2:106\n11400#2,3:107\n*S KotlinDebug\n*F\n+ 1 IndexUtils.kt\norg/opensearch/commons/alerting/util/IndexUtilsKt\n*L\n94#1:106\n94#1:107,3\n*E\n"})
public final class IndexUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBucketLevelMonitor(@NotNull Monitor $this$isBucketLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBucketLevelMonitor, (String)"<this>");
        if (!IndexUtilsKt.isMonitorOfStandardType($this$isBucketLevelMonitor)) return false;
        String string = $this$isBucketLevelMonitor.getMonitorType();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (Monitor.MonitorType.valueOf(string2) != Monitor.MonitorType.BUCKET_LEVEL_MONITOR) return false;
        return true;
    }

    @NotNull
    public static final XContentBuilder optionalUserField(@NotNull XContentBuilder $this$optionalUserField, @NotNull String name, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)$this$optionalUserField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (user == null) {
            XContentBuilder xContentBuilder = $this$optionalUserField.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"nullField(...)");
            return xContentBuilder;
        }
        XContentBuilder xContentBuilder = $this$optionalUserField.field(name, (ToXContent)user);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        return xContentBuilder;
    }

    @NotNull
    public static final XContentBuilder optionalUsernameField(@NotNull XContentBuilder $this$optionalUsernameField, @NotNull String name, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)$this$optionalUsernameField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (user == null) {
            XContentBuilder xContentBuilder = $this$optionalUsernameField.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"nullField(...)");
            return xContentBuilder;
        }
        XContentBuilder xContentBuilder = $this$optionalUsernameField.field(name, user.getName());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        return xContentBuilder;
    }

    @NotNull
    public static final XContentBuilder optionalTimeField(@NotNull XContentBuilder $this$optionalTimeField, @NotNull String name, @Nullable Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$optionalTimeField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (instant == null) {
            XContentBuilder xContentBuilder = $this$optionalTimeField.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"nullField(...)");
            return xContentBuilder;
        }
        XContentBuilder xContentBuilder = $this$optionalTimeField.timeField(name, name + "_in_millis", instant.toEpochMilli());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"timeField(...)");
        return xContentBuilder;
    }

    @Nullable
    public static final Instant instant(@NotNull XContentParser $this$instant) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$instant, (String)"<this>");
        if ($this$instant.currentToken() == XContentParser.Token.VALUE_NULL) {
            instant = null;
        } else if ($this$instant.currentToken().isValue()) {
            instant = Instant.ofEpochMilli($this$instant.longValue());
        } else {
            XContentParserUtils.throwUnknownToken((XContentParser.Token)$this$instant.currentToken(), (XContentLocation)$this$instant.getTokenLocation());
            instant = null;
        }
        return instant;
    }

    @NotNull
    public static final String string(@NotNull XContentBuilder $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        String string = BytesReference.bytes((XContentBuilder)$this$string).utf8ToString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"utf8ToString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isMonitorOfStandardType(@NotNull Monitor $this$isMonitorOfStandardType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isMonitorOfStandardType, (String)"<this>");
        Monitor.MonitorType[] $this$map$iv = Monitor.MonitorType.values();
        boolean $i$f$map = false;
        Monitor.MonitorType[] monitorTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getValue();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add(string2);
        }
        Set standardMonitorTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String string = $this$isMonitorOfStandardType.getMonitorType();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return standardMonitorTypes.contains(string3);
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull List<String> bucketKeys) {
        Intrinsics.checkNotNullParameter(bucketKeys, (String)"bucketKeys");
        return CollectionsKt.joinToString$default((Iterable)bucketKeys, (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull AggregationResultBucket $this$getBucketKeysHash) {
        Intrinsics.checkNotNullParameter((Object)$this$getBucketKeysHash, (String)"<this>");
        return IndexUtilsKt.getBucketKeysHash($this$getBucketKeysHash.getBucketKeys());
    }
}

