/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointServiceConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::dryRun)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::serviceId)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("ServiceId").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::privateDnsName)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("PrivateDnsName").build()}).build();
    private static final SdkField<Boolean> REMOVE_PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemovePrivateDnsName").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removePrivateDnsName)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removePrivateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrivateDnsName").unmarshallLocationName("RemovePrivateDnsName").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::acceptanceRequired)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("AcceptanceRequired").build()}).build();
    private static final SdkField<List<String>> ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddNetworkLoadBalancerArns").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::addNetworkLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::addNetworkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkLoadBalancerArn").unmarshallLocationName("AddNetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveNetworkLoadBalancerArns").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removeNetworkLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removeNetworkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkLoadBalancerArn").unmarshallLocationName("RemoveNetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddGatewayLoadBalancerArns").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::addGatewayLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::addGatewayLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddGatewayLoadBalancerArn").unmarshallLocationName("AddGatewayLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveGatewayLoadBalancerArns").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removeGatewayLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removeGatewayLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveGatewayLoadBalancerArn").unmarshallLocationName("RemoveGatewayLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSupportedIpAddressTypes").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::addSupportedIpAddressTypes)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::addSupportedIpAddressTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSupportedIpAddressType").unmarshallLocationName("AddSupportedIpAddressType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSupportedIpAddressTypes").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removeSupportedIpAddressTypes)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removeSupportedIpAddressTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSupportedIpAddressType").unmarshallLocationName("RemoveSupportedIpAddressType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SUPPORTED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSupportedRegions").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::addSupportedRegions)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::addSupportedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSupportedRegion").unmarshallLocationName("AddSupportedRegion").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUPPORTED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSupportedRegions").getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removeSupportedRegions)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removeSupportedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSupportedRegion").unmarshallLocationName("RemoveSupportedRegion").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, SERVICE_ID_FIELD, PRIVATE_DNS_NAME_FIELD, REMOVE_PRIVATE_DNS_NAME_FIELD, ACCEPTANCE_REQUIRED_FIELD, ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD, REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD, ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD, REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD, ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD, REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD, ADD_SUPPORTED_REGIONS_FIELD, REMOVE_SUPPORTED_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVpcEndpointServiceConfigurationRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String serviceId;
    private final String privateDnsName;
    private final Boolean removePrivateDnsName;
    private final Boolean acceptanceRequired;
    private final List<String> addNetworkLoadBalancerArns;
    private final List<String> removeNetworkLoadBalancerArns;
    private final List<String> addGatewayLoadBalancerArns;
    private final List<String> removeGatewayLoadBalancerArns;
    private final List<String> addSupportedIpAddressTypes;
    private final List<String> removeSupportedIpAddressTypes;
    private final List<String> addSupportedRegions;
    private final List<String> removeSupportedRegions;

    private ModifyVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.serviceId = builder.serviceId;
        this.privateDnsName = builder.privateDnsName;
        this.removePrivateDnsName = builder.removePrivateDnsName;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.addNetworkLoadBalancerArns = builder.addNetworkLoadBalancerArns;
        this.removeNetworkLoadBalancerArns = builder.removeNetworkLoadBalancerArns;
        this.addGatewayLoadBalancerArns = builder.addGatewayLoadBalancerArns;
        this.removeGatewayLoadBalancerArns = builder.removeGatewayLoadBalancerArns;
        this.addSupportedIpAddressTypes = builder.addSupportedIpAddressTypes;
        this.removeSupportedIpAddressTypes = builder.removeSupportedIpAddressTypes;
        this.addSupportedRegions = builder.addSupportedRegions;
        this.removeSupportedRegions = builder.removeSupportedRegions;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final Boolean removePrivateDnsName() {
        return this.removePrivateDnsName;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final boolean hasAddNetworkLoadBalancerArns() {
        return this.addNetworkLoadBalancerArns != null && !(this.addNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> addNetworkLoadBalancerArns() {
        return this.addNetworkLoadBalancerArns;
    }

    public final boolean hasRemoveNetworkLoadBalancerArns() {
        return this.removeNetworkLoadBalancerArns != null && !(this.removeNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> removeNetworkLoadBalancerArns() {
        return this.removeNetworkLoadBalancerArns;
    }

    public final boolean hasAddGatewayLoadBalancerArns() {
        return this.addGatewayLoadBalancerArns != null && !(this.addGatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> addGatewayLoadBalancerArns() {
        return this.addGatewayLoadBalancerArns;
    }

    public final boolean hasRemoveGatewayLoadBalancerArns() {
        return this.removeGatewayLoadBalancerArns != null && !(this.removeGatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> removeGatewayLoadBalancerArns() {
        return this.removeGatewayLoadBalancerArns;
    }

    public final boolean hasAddSupportedIpAddressTypes() {
        return this.addSupportedIpAddressTypes != null && !(this.addSupportedIpAddressTypes instanceof SdkAutoConstructList);
    }

    public final List<String> addSupportedIpAddressTypes() {
        return this.addSupportedIpAddressTypes;
    }

    public final boolean hasRemoveSupportedIpAddressTypes() {
        return this.removeSupportedIpAddressTypes != null && !(this.removeSupportedIpAddressTypes instanceof SdkAutoConstructList);
    }

    public final List<String> removeSupportedIpAddressTypes() {
        return this.removeSupportedIpAddressTypes;
    }

    public final boolean hasAddSupportedRegions() {
        return this.addSupportedRegions != null && !(this.addSupportedRegions instanceof SdkAutoConstructList);
    }

    public final List<String> addSupportedRegions() {
        return this.addSupportedRegions;
    }

    public final boolean hasRemoveSupportedRegions() {
        return this.removeSupportedRegions != null && !(this.removeSupportedRegions instanceof SdkAutoConstructList);
    }

    public final List<String> removeSupportedRegions() {
        return this.removeSupportedRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.removePrivateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddNetworkLoadBalancerArns() ? this.addNetworkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveNetworkLoadBalancerArns() ? this.removeNetworkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddGatewayLoadBalancerArns() ? this.addGatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveGatewayLoadBalancerArns() ? this.removeGatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSupportedIpAddressTypes() ? this.addSupportedIpAddressTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSupportedIpAddressTypes() ? this.removeSupportedIpAddressTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSupportedRegions() ? this.addSupportedRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSupportedRegions() ? this.removeSupportedRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        ModifyVpcEndpointServiceConfigurationRequest other = (ModifyVpcEndpointServiceConfigurationRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.removePrivateDnsName(), other.removePrivateDnsName()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && this.hasAddNetworkLoadBalancerArns() == other.hasAddNetworkLoadBalancerArns() && Objects.equals(this.addNetworkLoadBalancerArns(), other.addNetworkLoadBalancerArns()) && this.hasRemoveNetworkLoadBalancerArns() == other.hasRemoveNetworkLoadBalancerArns() && Objects.equals(this.removeNetworkLoadBalancerArns(), other.removeNetworkLoadBalancerArns()) && this.hasAddGatewayLoadBalancerArns() == other.hasAddGatewayLoadBalancerArns() && Objects.equals(this.addGatewayLoadBalancerArns(), other.addGatewayLoadBalancerArns()) && this.hasRemoveGatewayLoadBalancerArns() == other.hasRemoveGatewayLoadBalancerArns() && Objects.equals(this.removeGatewayLoadBalancerArns(), other.removeGatewayLoadBalancerArns()) && this.hasAddSupportedIpAddressTypes() == other.hasAddSupportedIpAddressTypes() && Objects.equals(this.addSupportedIpAddressTypes(), other.addSupportedIpAddressTypes()) && this.hasRemoveSupportedIpAddressTypes() == other.hasRemoveSupportedIpAddressTypes() && Objects.equals(this.removeSupportedIpAddressTypes(), other.removeSupportedIpAddressTypes()) && this.hasAddSupportedRegions() == other.hasAddSupportedRegions() && Objects.equals(this.addSupportedRegions(), other.addSupportedRegions()) && this.hasRemoveSupportedRegions() == other.hasRemoveSupportedRegions() && Objects.equals(this.removeSupportedRegions(), other.removeSupportedRegions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcEndpointServiceConfigurationRequest").add("DryRun", (Object)this.dryRun()).add("ServiceId", (Object)this.serviceId()).add("PrivateDnsName", (Object)this.privateDnsName()).add("RemovePrivateDnsName", (Object)this.removePrivateDnsName()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("AddNetworkLoadBalancerArns", this.hasAddNetworkLoadBalancerArns() ? this.addNetworkLoadBalancerArns() : null).add("RemoveNetworkLoadBalancerArns", this.hasRemoveNetworkLoadBalancerArns() ? this.removeNetworkLoadBalancerArns() : null).add("AddGatewayLoadBalancerArns", this.hasAddGatewayLoadBalancerArns() ? this.addGatewayLoadBalancerArns() : null).add("RemoveGatewayLoadBalancerArns", this.hasRemoveGatewayLoadBalancerArns() ? this.removeGatewayLoadBalancerArns() : null).add("AddSupportedIpAddressTypes", this.hasAddSupportedIpAddressTypes() ? this.addSupportedIpAddressTypes() : null).add("RemoveSupportedIpAddressTypes", this.hasRemoveSupportedIpAddressTypes() ? this.removeSupportedIpAddressTypes() : null).add("AddSupportedRegions", this.hasAddSupportedRegions() ? this.addSupportedRegions() : null).add("RemoveSupportedRegions", this.hasRemoveSupportedRegions() ? this.removeSupportedRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "RemovePrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.removePrivateDnsName()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "AddNetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.addNetworkLoadBalancerArns()));
            }
            case "RemoveNetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.removeNetworkLoadBalancerArns()));
            }
            case "AddGatewayLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.addGatewayLoadBalancerArns()));
            }
            case "RemoveGatewayLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.removeGatewayLoadBalancerArns()));
            }
            case "AddSupportedIpAddressTypes": {
                return Optional.ofNullable(clazz.cast(this.addSupportedIpAddressTypes()));
            }
            case "RemoveSupportedIpAddressTypes": {
                return Optional.ofNullable(clazz.cast(this.removeSupportedIpAddressTypes()));
            }
            case "AddSupportedRegions": {
                return Optional.ofNullable(clazz.cast(this.addSupportedRegions()));
            }
            case "RemoveSupportedRegions": {
                return Optional.ofNullable(clazz.cast(this.removeSupportedRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
        map.put("RemovePrivateDnsName", REMOVE_PRIVATE_DNS_NAME_FIELD);
        map.put("AcceptanceRequired", ACCEPTANCE_REQUIRED_FIELD);
        map.put("AddNetworkLoadBalancerArn", ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD);
        map.put("RemoveNetworkLoadBalancerArn", REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD);
        map.put("AddGatewayLoadBalancerArn", ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD);
        map.put("RemoveGatewayLoadBalancerArn", REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD);
        map.put("AddSupportedIpAddressType", ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD);
        map.put("RemoveSupportedIpAddressType", REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD);
        map.put("AddSupportedRegion", ADD_SUPPORTED_REGIONS_FIELD);
        map.put("RemoveSupportedRegion", REMOVE_SUPPORTED_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServiceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String serviceId;
        private String privateDnsName;
        private Boolean removePrivateDnsName;
        private Boolean acceptanceRequired;
        private List<String> addNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> addGatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeGatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSupportedIpAddressTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSupportedIpAddressTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSupportedRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSupportedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServiceConfigurationRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.serviceId(model.serviceId);
            this.privateDnsName(model.privateDnsName);
            this.removePrivateDnsName(model.removePrivateDnsName);
            this.acceptanceRequired(model.acceptanceRequired);
            this.addNetworkLoadBalancerArns(model.addNetworkLoadBalancerArns);
            this.removeNetworkLoadBalancerArns(model.removeNetworkLoadBalancerArns);
            this.addGatewayLoadBalancerArns(model.addGatewayLoadBalancerArns);
            this.removeGatewayLoadBalancerArns(model.removeGatewayLoadBalancerArns);
            this.addSupportedIpAddressTypes(model.addSupportedIpAddressTypes);
            this.removeSupportedIpAddressTypes(model.removeSupportedIpAddressTypes);
            this.addSupportedRegions(model.addSupportedRegions);
            this.removeSupportedRegions(model.removeSupportedRegions);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final Boolean getRemovePrivateDnsName() {
            return this.removePrivateDnsName;
        }

        public final void setRemovePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
        }

        @Override
        public final Builder removePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
            return this;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final Collection<String> getAddNetworkLoadBalancerArns() {
            if (this.addNetworkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addNetworkLoadBalancerArns;
        }

        public final void setAddNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
        }

        @Override
        public final Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkLoadBalancerArns(String ... addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns(Arrays.asList(addNetworkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getRemoveNetworkLoadBalancerArns() {
            if (this.removeNetworkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeNetworkLoadBalancerArns;
        }

        public final void setRemoveNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
        }

        @Override
        public final Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkLoadBalancerArns(String ... removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns(Arrays.asList(removeNetworkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getAddGatewayLoadBalancerArns() {
            if (this.addGatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addGatewayLoadBalancerArns;
        }

        public final void setAddGatewayLoadBalancerArns(Collection<String> addGatewayLoadBalancerArns) {
            this.addGatewayLoadBalancerArns = ValueStringListCopier.copy(addGatewayLoadBalancerArns);
        }

        @Override
        public final Builder addGatewayLoadBalancerArns(Collection<String> addGatewayLoadBalancerArns) {
            this.addGatewayLoadBalancerArns = ValueStringListCopier.copy(addGatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addGatewayLoadBalancerArns(String ... addGatewayLoadBalancerArns) {
            this.addGatewayLoadBalancerArns(Arrays.asList(addGatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getRemoveGatewayLoadBalancerArns() {
            if (this.removeGatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeGatewayLoadBalancerArns;
        }

        public final void setRemoveGatewayLoadBalancerArns(Collection<String> removeGatewayLoadBalancerArns) {
            this.removeGatewayLoadBalancerArns = ValueStringListCopier.copy(removeGatewayLoadBalancerArns);
        }

        @Override
        public final Builder removeGatewayLoadBalancerArns(Collection<String> removeGatewayLoadBalancerArns) {
            this.removeGatewayLoadBalancerArns = ValueStringListCopier.copy(removeGatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeGatewayLoadBalancerArns(String ... removeGatewayLoadBalancerArns) {
            this.removeGatewayLoadBalancerArns(Arrays.asList(removeGatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getAddSupportedIpAddressTypes() {
            if (this.addSupportedIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSupportedIpAddressTypes;
        }

        public final void setAddSupportedIpAddressTypes(Collection<String> addSupportedIpAddressTypes) {
            this.addSupportedIpAddressTypes = ValueStringListCopier.copy(addSupportedIpAddressTypes);
        }

        @Override
        public final Builder addSupportedIpAddressTypes(Collection<String> addSupportedIpAddressTypes) {
            this.addSupportedIpAddressTypes = ValueStringListCopier.copy(addSupportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSupportedIpAddressTypes(String ... addSupportedIpAddressTypes) {
            this.addSupportedIpAddressTypes(Arrays.asList(addSupportedIpAddressTypes));
            return this;
        }

        public final Collection<String> getRemoveSupportedIpAddressTypes() {
            if (this.removeSupportedIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSupportedIpAddressTypes;
        }

        public final void setRemoveSupportedIpAddressTypes(Collection<String> removeSupportedIpAddressTypes) {
            this.removeSupportedIpAddressTypes = ValueStringListCopier.copy(removeSupportedIpAddressTypes);
        }

        @Override
        public final Builder removeSupportedIpAddressTypes(Collection<String> removeSupportedIpAddressTypes) {
            this.removeSupportedIpAddressTypes = ValueStringListCopier.copy(removeSupportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSupportedIpAddressTypes(String ... removeSupportedIpAddressTypes) {
            this.removeSupportedIpAddressTypes(Arrays.asList(removeSupportedIpAddressTypes));
            return this;
        }

        public final Collection<String> getAddSupportedRegions() {
            if (this.addSupportedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSupportedRegions;
        }

        public final void setAddSupportedRegions(Collection<String> addSupportedRegions) {
            this.addSupportedRegions = ValueStringListCopier.copy(addSupportedRegions);
        }

        @Override
        public final Builder addSupportedRegions(Collection<String> addSupportedRegions) {
            this.addSupportedRegions = ValueStringListCopier.copy(addSupportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSupportedRegions(String ... addSupportedRegions) {
            this.addSupportedRegions(Arrays.asList(addSupportedRegions));
            return this;
        }

        public final Collection<String> getRemoveSupportedRegions() {
            if (this.removeSupportedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSupportedRegions;
        }

        public final void setRemoveSupportedRegions(Collection<String> removeSupportedRegions) {
            this.removeSupportedRegions = ValueStringListCopier.copy(removeSupportedRegions);
        }

        @Override
        public final Builder removeSupportedRegions(Collection<String> removeSupportedRegions) {
            this.removeSupportedRegions = ValueStringListCopier.copy(removeSupportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSupportedRegions(String ... removeSupportedRegions) {
            this.removeSupportedRegions(Arrays.asList(removeSupportedRegions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServiceConfigurationRequest build() {
            return new ModifyVpcEndpointServiceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
        public Builder dryRun(Boolean var1);

        public Builder serviceId(String var1);

        public Builder privateDnsName(String var1);

        public Builder removePrivateDnsName(Boolean var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder addNetworkLoadBalancerArns(Collection<String> var1);

        public Builder addNetworkLoadBalancerArns(String ... var1);

        public Builder removeNetworkLoadBalancerArns(Collection<String> var1);

        public Builder removeNetworkLoadBalancerArns(String ... var1);

        public Builder addGatewayLoadBalancerArns(Collection<String> var1);

        public Builder addGatewayLoadBalancerArns(String ... var1);

        public Builder removeGatewayLoadBalancerArns(Collection<String> var1);

        public Builder removeGatewayLoadBalancerArns(String ... var1);

        public Builder addSupportedIpAddressTypes(Collection<String> var1);

        public Builder addSupportedIpAddressTypes(String ... var1);

        public Builder removeSupportedIpAddressTypes(Collection<String> var1);

        public Builder removeSupportedIpAddressTypes(String ... var1);

        public Builder addSupportedRegions(Collection<String> var1);

        public Builder addSupportedRegions(String ... var1);

        public Builder removeSupportedRegions(Collection<String> var1);

        public Builder removeSupportedRegions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

