/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.mtermvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch.core.termvectors.TermVector;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MultiTermVectorsResult
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, MultiTermVectorsResult> {
    @Nullable
    private final ErrorCause error;
    @Nullable
    private final Boolean found;
    @Nonnull
    private final String id;
    @Nonnull
    private final String index;
    @Nonnull
    private final Map<String, TermVector> termVectors;
    @Nullable
    private final Long took;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<MultiTermVectorsResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermVectorsResult::setupMultiTermVectorsResultDeserializer);

    private MultiTermVectorsResult(Builder builder) {
        this.error = builder.error;
        this.found = builder.found;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.termVectors = ApiTypeHelper.unmodifiable(builder.termVectors);
        this.took = builder.took;
        this.version = builder.version;
    }

    public static MultiTermVectorsResult of(Function<Builder, ObjectBuilder<MultiTermVectorsResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Nullable
    public final Boolean found() {
        return this.found;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final Map<String, TermVector> termVectors() {
        return this.termVectors;
    }

    @Nullable
    public final Long took() {
        return this.took;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        if (this.found != null) {
            generator.writeKey("found");
            generator.write(this.found.booleanValue());
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.termVectors)) {
            generator.writeKey("term_vectors");
            generator.writeStartObject();
            for (Map.Entry<String, TermVector> item0 : this.termVectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMultiTermVectorsResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::termVectors, JsonpDeserializer.stringMapDeserializer(TermVector._DESERIALIZER), "term_vectors");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.error);
        result = 31 * result + Objects.hashCode(this.found);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.termVectors);
        result = 31 * result + Objects.hashCode(this.took);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermVectorsResult other = (MultiTermVectorsResult)o;
        return Objects.equals(this.error, other.error) && Objects.equals(this.found, other.found) && this.id.equals(other.id) && this.index.equals(other.index) && Objects.equals(this.termVectors, other.termVectors) && Objects.equals(this.took, other.took) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, MultiTermVectorsResult> {
        @Nullable
        private ErrorCause error;
        @Nullable
        private Boolean found;
        private String id;
        private String index;
        @Nullable
        private Map<String, TermVector> termVectors;
        @Nullable
        private Long took;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(MultiTermVectorsResult o) {
            this.error = o.error;
            this.found = o.found;
            this.id = o.id;
            this.index = o.index;
            this.termVectors = Builder._mapCopy(o.termVectors);
            this.took = o.took;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.error = o.error;
            this.found = o.found;
            this.id = o.id;
            this.index = o.index;
            this.termVectors = Builder._mapCopy(o.termVectors);
            this.took = o.took;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        @Nonnull
        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Nonnull
        public final Builder found(@Nullable Boolean value) {
            this.found = value;
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder termVectors(Map<String, TermVector> map) {
            this.termVectors = Builder._mapPutAll(this.termVectors, map);
            return this;
        }

        @Nonnull
        public final Builder termVectors(String key, TermVector value) {
            this.termVectors = Builder._mapPut(this.termVectors, key, value);
            return this;
        }

        @Nonnull
        public final Builder termVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.termVectors(key, fn.apply(new TermVector.Builder()).build());
        }

        @Nonnull
        public final Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public MultiTermVectorsResult build() {
            this._checkSingleUse();
            return new MultiTermVectorsResult(this);
        }
    }
}

