/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerSubState;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerStatus {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerStatus newInstance(ContainerId containerId, ContainerState containerState, String diagnostics, int exitStatus) {
        return ContainerStatus.newInstance(containerId, ExecutionType.GUARANTEED, containerState, diagnostics, exitStatus);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerStatus newInstance(ContainerId containerId, ExecutionType executionType, ContainerState containerState, String diagnostics, int exitStatus) {
        ContainerStatus containerStatus = Records.newRecord(ContainerStatus.class);
        containerStatus.setExecutionType(executionType);
        containerStatus.setState(containerState);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        return containerStatus;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerId getContainerId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setContainerId(ContainerId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public ExecutionType getExecutionType() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setExecutionType(ExecutionType executionType) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerState getState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setState(ContainerState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getExitStatus();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExitStatus(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDiagnostics();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setDiagnostics(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Resource getCapability() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setCapability(Resource capability) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public List<String> getIPs() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setIPs(List<String> ips) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public String getHost() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setHost(String host) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setContainerSubState(ContainerSubState subState) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ContainerSubState getContainerSubState() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public String getExposedPorts() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setExposedPorts(String ports) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }
}

