/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreDescriptor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CORE_NAME = "name";
    public static final String CORE_CONFIG = "config";
    public static final String CORE_DATADIR = "dataDir";
    public static final String CORE_ULOGDIR = "ulogDir";
    public static final String CORE_SCHEMA = "schema";
    public static final String CORE_SHARD = "shard";
    public static final String CORE_COLLECTION = "collection";
    public static final String CORE_ROLES = "roles";
    public static final String CORE_PROPERTIES = "properties";
    public static final String CORE_LOADONSTARTUP = "loadOnStartup";
    public static final String CORE_TRANSIENT = "transient";
    public static final String CORE_NODE_NAME = "coreNodeName";
    public static final String CORE_CONFIGSET = "configSet";
    public static final String CORE_CONFIGSET_PROPERTIES = "configSetProperties";
    public static final String SOLR_CORE_PROP_PREFIX = "solr.core.";
    public static final String DEFAULT_EXTERNAL_PROPERTIES_FILE = "conf" + File.separator + "solrcore.properties";
    private boolean trustedConfigSet = true;
    private static final Map<String, String> defaultProperties = Map.of("config", "solrconfig.xml", "schema", "schema.xml", "configSetProperties", "configsetprops.json", "dataDir", "data" + File.separator, "transient", "false", "loadOnStartup", "true");
    private static final List<String> requiredProperties = List.of("name");
    public static List<String> standardPropNames = List.of("name", "config", "dataDir", "ulogDir", "schema", "properties", "configSetProperties", "loadOnStartup", "transient", "configSet", "shard", "collection", "roles", "coreNodeName", "numShards");
    private final CloudDescriptor cloudDesc;
    private final Path instanceDir;
    protected final Properties originalCoreProperties = new Properties();
    protected final Properties originalExtraProperties = new Properties();
    protected final Properties coreProperties = new Properties();
    protected final Properties substitutableProperties = new Properties();

    public Properties getPersistableStandardProperties() {
        return this.originalCoreProperties;
    }

    public Properties getPersistableUserProperties() {
        return this.originalExtraProperties;
    }

    public CoreDescriptor(String name, Path instanceDir, CoreContainer coreContainer, String ... coreProps) {
        this(name, instanceDir, CoreDescriptor.toMap(coreProps), coreContainer.getContainerProperties(), coreContainer.getZkController());
    }

    private static Map<String, String> toMap(String ... properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        assert (properties.length % 2 == 0);
        for (int i = 0; i < properties.length; i += 2) {
            props.put(properties[i], properties[i + 1]);
        }
        return props;
    }

    public CoreDescriptor(String coreName, CoreDescriptor other) {
        this.cloudDesc = other.cloudDesc;
        this.instanceDir = other.instanceDir;
        this.originalExtraProperties.putAll((Map<?, ?>)other.originalExtraProperties);
        this.originalCoreProperties.putAll((Map<?, ?>)other.originalCoreProperties);
        this.coreProperties.putAll((Map<?, ?>)other.coreProperties);
        this.substitutableProperties.putAll((Map<?, ?>)other.substitutableProperties);
        this.coreProperties.setProperty(CORE_NAME, coreName);
        this.originalCoreProperties.setProperty(CORE_NAME, coreName);
        this.substitutableProperties.setProperty("solr.core.name", coreName);
        this.trustedConfigSet = other.trustedConfigSet;
    }

    public CoreDescriptor(String name, Path instanceDir, Map<String, String> coreProps, Properties containerProperties, ZkController zkController) {
        this.instanceDir = instanceDir;
        assert (instanceDir.isAbsolute());
        this.originalCoreProperties.setProperty(CORE_NAME, name);
        name = PropertiesUtil.substituteProperty((String)CoreDescriptor.checkPropertyIsNotEmpty(name, CORE_NAME), (Properties)containerProperties);
        this.coreProperties.putAll(defaultProperties);
        this.coreProperties.put(CORE_NAME, name);
        for (Map.Entry<String, String> entry : coreProps.entrySet()) {
            String propname = entry.getKey();
            String propvalue = entry.getValue();
            if (CoreDescriptor.isUserDefinedProperty(propname)) {
                this.originalExtraProperties.put(propname, propvalue);
            } else {
                this.originalCoreProperties.put(propname, propvalue);
            }
            if (requiredProperties.contains(propname)) continue;
            this.coreProperties.setProperty(propname, PropertiesUtil.substituteProperty((String)propvalue, (Properties)containerProperties));
        }
        this.loadExtraProperties();
        this.buildSubstitutableProperties();
        this.cloudDesc = zkController != null ? new CloudDescriptor(this, name, this.coreProperties) : null;
        log.debug("Created CoreDescriptor: {}", (Object)this.coreProperties);
    }

    protected void loadExtraProperties() {
        String filename = this.coreProperties.getProperty(CORE_PROPERTIES, DEFAULT_EXTERNAL_PROPERTIES_FILE);
        Path propertiesFile = this.instanceDir.resolve(filename);
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(propertiesFile, StandardCharsets.UTF_8);){
                Properties externalProps = new Properties();
                externalProps.load(r);
                this.coreProperties.putAll((Map<?, ?>)externalProps);
            }
            catch (IOException e) {
                String message = String.format(Locale.ROOT, "Could not load properties from %s: %s:", propertiesFile, e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildSubstitutableProperties() {
        for (String string : this.coreProperties.stringPropertyNames()) {
            void var2_2;
            String propValue = this.coreProperties.getProperty(string);
            if (!CoreDescriptor.isUserDefinedProperty(string)) {
                String string2 = SOLR_CORE_PROP_PREFIX + string;
            }
            this.substitutableProperties.setProperty((String)var2_2, propValue);
        }
        this.substitutableProperties.setProperty("solr.core.instanceDir", this.instanceDir.toString());
    }

    protected static boolean isUserDefinedProperty(String propName) {
        return !standardPropNames.contains(propName);
    }

    public static String checkPropertyIsNotEmpty(String value, String propName) {
        if (StrUtils.isNullOrEmpty((String)value)) {
            String message = String.format(Locale.ROOT, "Cannot create core with empty %s value", propName);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
        }
        return value;
    }

    public String getPropertiesName() {
        return this.coreProperties.getProperty(CORE_PROPERTIES);
    }

    public String getDataDir() {
        return this.coreProperties.getProperty(CORE_DATADIR);
    }

    public boolean usingDefaultDataDir() {
        return defaultProperties.get(CORE_DATADIR).equals(this.coreProperties.getProperty(CORE_DATADIR));
    }

    public Path getInstanceDir() {
        return this.instanceDir;
    }

    public String getConfigName() {
        return this.coreProperties.getProperty(CORE_CONFIG);
    }

    public String getSchemaName() {
        return this.coreProperties.getProperty(CORE_SCHEMA);
    }

    public String getName() {
        return this.coreProperties.getProperty(CORE_NAME);
    }

    void setProperty(String prop, String val) {
        if (this.substitutableProperties.containsKey(prop)) {
            this.substitutableProperties.setProperty(prop, val);
            return;
        }
        this.coreProperties.setProperty(prop, val);
    }

    public String getCollectionName() {
        return this.cloudDesc == null ? null : this.cloudDesc.getCollectionName();
    }

    public CloudDescriptor getCloudDescriptor() {
        return this.cloudDesc;
    }

    public boolean isLoadOnStartup() {
        String stringValue = this.coreProperties.getProperty(CORE_LOADONSTARTUP, "true");
        return Boolean.parseBoolean(stringValue);
    }

    public boolean isTransient() {
        String stringValue = this.coreProperties.getProperty(CORE_TRANSIENT, "false");
        return PropertiesUtil.toBoolean((String)stringValue);
    }

    public String getUlogDir() {
        return this.coreProperties.getProperty(CORE_ULOGDIR);
    }

    public String getCoreProperty(String prop, String defVal) {
        return this.coreProperties.getProperty(prop, defVal);
    }

    public Properties getSubstitutableProperties() {
        return this.substitutableProperties;
    }

    public String toString() {
        return "CoreDescriptor[name=" + this.getName() + ";instanceDir=" + String.valueOf(this.getInstanceDir()) + "]";
    }

    public String getConfigSet() {
        return this.coreProperties.getProperty(CORE_CONFIGSET);
    }

    public void setConfigSet(String configSetName) {
        this.coreProperties.setProperty(CORE_CONFIGSET, configSetName);
    }

    public String getConfigSetPropertiesName() {
        return this.coreProperties.getProperty(CORE_CONFIGSET_PROPERTIES);
    }

    public boolean isConfigSetTrusted() {
        return this.trustedConfigSet;
    }

    public void setConfigSetTrusted(boolean trusted) {
        this.trustedConfigSet = trusted;
    }
}

