/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.DocIterationInfo;

public class DocTransformers
extends DocTransformer {
    final List<DocTransformer> children = new ArrayList<DocTransformer>();

    @Override
    public String getName() {
        StringBuilder str = new StringBuilder();
        str.append("Transformers[");
        Iterator<DocTransformer> iter = this.children.iterator();
        while (iter.hasNext()) {
            str.append(iter.next().getName());
            if (!iter.hasNext()) continue;
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public Collection<String> getRawFields() {
        return this.children.stream().map(DocTransformer::getRawFields).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void addTransformer(DocTransformer a) {
        this.children.add(a);
    }

    public int size() {
        return this.children.size();
    }

    public DocTransformer getTransformer(int idx) {
        return this.children.get(idx);
    }

    @Override
    public void setContext(ResultContext context) {
        for (DocTransformer a : this.children) {
            a.setContext(context);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid, DocIterationInfo docInfo) throws IOException {
        for (DocTransformer a : this.children) {
            a.transform(doc, docid, docInfo);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid) throws IOException {
        for (DocTransformer a : this.children) {
            a.transform(doc, docid);
        }
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        return this.children.stream().anyMatch(DocTransformer::needsSolrIndexSearcher);
    }
}

