/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.facet.compare.ConstantComparator;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.constant.ConstantValue;

public class ConstantIntValue
extends ConstantValue
implements IntValue.CastingIntValue {
    private final int value;
    private final String valueStr;
    public static final String name = "const_int";
    private final String exprStr;

    public ConstantIntValue(int value) {
        this.value = value;
        this.valueStr = Integer.toString(value);
        this.exprStr = ConstantValue.createExpressionString(this, this.valueStr);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.valueStr;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void streamInts(IntConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        cons.accept(this.valueStr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        cons.accept(this.value);
    }

    @Override
    public ConstantComparator getObjectComparator(String expression) {
        return new ConstantComparator();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.CONST;
    }
}

