/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.CMsgWriter;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.ConnFailedException;
import com.tigervnc.rfb.DecodeManager;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.SecurityClient;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class CConnection
extends CMsgHandler {
    static LogWriter vlog = new LogWriter("CConnection");
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    public CSecurity csecurity = null;
    public SecurityClient security;
    protected boolean supportsLocalCursor = false;
    protected boolean supportsDesktopResize = false;
    private InStream is = null;
    private OutStream os = null;
    private CMsgReader reader_ = null;
    private CMsgWriter writer_ = null;
    private boolean deleteStreamsWhenDone;
    private boolean shared = false;
    private stateEnum state_ = stateEnum.RFBSTATE_UNINITIALISED;
    private String serverName;
    private int serverPort;
    private boolean pendingPFChange = false;
    private PixelFormat pendingPF;
    private int preferredEncoding = 7;
    private int compressLevel = 2;
    private int qualityLevel = -1;
    private boolean formatChange = false;
    private PixelFormat nextPF;
    private boolean encodingChange = false;
    private boolean firstUpdate = true;
    private boolean pendingUpdate = false;
    private boolean continuousUpdates = false;
    private boolean forceNonincremental = true;
    protected ModifiablePixelBuffer framebuffer = null;
    private DecodeManager decoder = new DecodeManager(this);

    public CConnection() {
        this.security = new SecurityClient();
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    public final void setStreams(InStream inStream, OutStream outStream) {
        this.is = inStream;
        this.os = outStream;
    }

    public final void setShared(boolean bl) {
        this.shared = bl;
    }

    public void setFramebuffer(ModifiablePixelBuffer modifiablePixelBuffer) {
        this.decoder.flush();
        if (modifiablePixelBuffer != null) {
            assert (modifiablePixelBuffer.width() == this.server.width());
            assert (modifiablePixelBuffer.height() == this.server.height());
        }
        if (this.framebuffer != null && modifiablePixelBuffer != null) {
            Rect rect = new Rect();
            byte[] byArray = new byte[4];
            rect.setXYWH(0, 0, Math.min(modifiablePixelBuffer.width(), this.framebuffer.width()), Math.min(modifiablePixelBuffer.height(), this.framebuffer.height()));
            Raster raster = this.framebuffer.getBuffer(rect);
            modifiablePixelBuffer.imageRect(this.framebuffer.getPF(), rect, raster);
            if (modifiablePixelBuffer.width() > this.framebuffer.width()) {
                rect.setXYWH(this.framebuffer.width(), 0, modifiablePixelBuffer.width() - this.framebuffer.width(), modifiablePixelBuffer.height());
                modifiablePixelBuffer.fillRect(rect, byArray);
            }
            if (modifiablePixelBuffer.height() > this.framebuffer.height()) {
                rect.setXYWH(0, this.framebuffer.height(), modifiablePixelBuffer.width(), modifiablePixelBuffer.height() - this.framebuffer.height());
                modifiablePixelBuffer.fillRect(rect, byArray);
            }
        }
        this.framebuffer = modifiablePixelBuffer;
    }

    public final void initialiseProtocol() {
        this.state_ = stateEnum.RFBSTATE_PROTOCOL_VERSION;
    }

    public void processMsg() {
        switch (this.state_) {
            case RFBSTATE_PROTOCOL_VERSION: {
                this.processVersionMsg();
                break;
            }
            case RFBSTATE_SECURITY_TYPES: {
                this.processSecurityTypesMsg();
                break;
            }
            case RFBSTATE_SECURITY: {
                this.processSecurityMsg();
                break;
            }
            case RFBSTATE_SECURITY_RESULT: {
                this.processSecurityResultMsg();
                break;
            }
            case RFBSTATE_INITIALISATION: {
                this.processInitMsg();
                break;
            }
            case RFBSTATE_NORMAL: {
                this.reader_.readMsg();
                break;
            }
            case RFBSTATE_UNINITIALISED: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    private void processVersionMsg() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        vlog.debug("Reading protocol version", new Object[0]);
        if (!this.is.checkNoWait(12)) {
            return;
        }
        this.is.readBytes(byteBuffer, 12);
        if (!new String(byteBuffer.array()).matches("RFB \\d{3}\\.\\d{3}\\n")) {
            this.state_ = stateEnum.RFBSTATE_INVALID;
            throw new Exception("reading version failed: not an RFB server?");
        }
        int n = Integer.parseInt(new String(byteBuffer.array()).substring(4, 7));
        int n2 = Integer.parseInt(new String(byteBuffer.array()).substring(8, 11));
        this.server.setVersion(n, n2);
        vlog.info("Server supports RFB protocol version " + this.server.majorVersion + "." + this.server.minorVersion, new Object[0]);
        if (this.server.beforeVersion(3, 3)) {
            String string = "Server gave unsupported RFB protocol version " + this.server.majorVersion + "." + this.server.minorVersion;
            vlog.error(string, new Object[0]);
            this.state_ = stateEnum.RFBSTATE_INVALID;
            throw new Exception(string);
        }
        if (this.server.beforeVersion(3, 7)) {
            this.server.setVersion(3, 3);
        } else if (this.server.afterVersion(3, 8)) {
            this.server.setVersion(3, 8);
        }
        byteBuffer.clear();
        byteBuffer.put(String.format("RFB %03d.%03d\n", this.server.majorVersion, this.server.minorVersion).getBytes()).flip();
        this.os.writeBytes(byteBuffer.array(), 0, 12);
        this.os.flush();
        this.state_ = stateEnum.RFBSTATE_SECURITY_TYPES;
        vlog.info("Using RFB protocol version " + this.server.majorVersion + "." + this.server.minorVersion, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSecurityTypesMsg() {
        int n;
        block11: {
            List<Object> list;
            block10: {
                vlog.debug("Processing security types message", new Object[0]);
                n = 0;
                list = new ArrayList();
                list = this.security.GetEnabledSecTypes();
                if (!this.server.isVersion(3, 3)) break block10;
                n = this.is.readU32();
                if (n == 0) {
                    this.throwConnFailedException();
                    break block11;
                } else {
                    if (n != 1 && n != 2) {
                        vlog.error("Unknown 3.3 security type " + n, new Object[0]);
                        throw new Exception("Unknown 3.3 security type");
                    }
                    Iterator<Object> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int n2 = (Integer)iterator.next();
                        if (n2 != n) continue;
                        n = n2;
                        break;
                    }
                    if (!list.contains(n)) {
                        n = 0;
                    }
                }
                break block11;
            }
            int n3 = this.is.readU8();
            if (n3 == 0) {
                this.throwConnFailedException();
            }
            block1: for (int i = 0; i < n3; ++i) {
                int n4 = this.is.readU8();
                vlog.debug("Server offers security type " + Security.secTypeName(n4) + "(" + n4 + ")", new Object[0]);
                if (n != 0) continue;
                Iterator<Object> iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    if (n5 != n4) continue;
                    n = n5;
                    continue block1;
                }
            }
            if (n != 0) {
                this.os.writeU8(n);
                this.os.flush();
                vlog.debug("Choosing security type " + Security.secTypeName(n) + "(" + n + ")", new Object[0]);
            }
        }
        if (n == 0) {
            this.state_ = stateEnum.RFBSTATE_INVALID;
            vlog.error("No matching security types", new Object[0]);
            throw new Exception("No matching security types");
        }
        this.state_ = stateEnum.RFBSTATE_SECURITY;
        this.csecurity = this.security.GetCSecurity(n);
        this.processSecurityMsg();
    }

    private void processSecurityMsg() {
        vlog.debug("Processing security message", new Object[0]);
        if (this.csecurity.processMsg(this)) {
            this.state_ = stateEnum.RFBSTATE_SECURITY_RESULT;
            this.processSecurityResultMsg();
        }
    }

    private void processSecurityResultMsg() {
        int n;
        vlog.debug("Processing security result message", new Object[0]);
        if (this.server.beforeVersion(3, 8) && this.csecurity.getType() == 1) {
            n = 0;
        } else {
            if (!this.is.checkNoWait(1)) {
                return;
            }
            n = this.is.readU32();
        }
        switch (n) {
            case 0: {
                this.securityCompleted();
                return;
            }
            case 1: {
                vlog.debug("Auth failed", new Object[0]);
                break;
            }
            case 2: {
                vlog.debug("Auth failed: Too many tries", new Object[0]);
                break;
            }
            default: {
                throw new Exception("Unknown security result from server");
            }
        }
        this.state_ = stateEnum.RFBSTATE_INVALID;
        if (this.server.beforeVersion(3, 8)) {
            throw new AuthFailureException();
        }
        String string = this.is.readString();
        throw new AuthFailureException(string);
    }

    private void processInitMsg() {
        vlog.debug("Reading server initialisation", new Object[0]);
        this.reader_.readServerInit();
    }

    private void throwConnFailedException() {
        this.state_ = stateEnum.RFBSTATE_INVALID;
        String string = this.is.readString();
        throw new ConnFailedException(string);
    }

    private void securityCompleted() {
        this.state_ = stateEnum.RFBSTATE_INITIALISATION;
        this.reader_ = new CMsgReader(this, this.is);
        this.writer_ = new CMsgWriter(this.server, this.os);
        vlog.debug("Authentication success!", new Object[0]);
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }

    @Override
    public void setDesktopSize(int n, int n2) {
        this.decoder.flush();
        super.setDesktopSize(n, n2);
        if (this.continuousUpdates) {
            this.writer().writeEnableContinuousUpdates(true, 0, 0, this.server.width(), this.server.height());
        }
        this.resizeFramebuffer();
        assert (this.framebuffer != null);
        assert (this.framebuffer.width() == this.server.width());
        assert (this.framebuffer.height() == this.server.height());
    }

    @Override
    public void setExtendedDesktopSize(int n, int n2, int n3, int n4, ScreenSet screenSet) {
        this.decoder.flush();
        super.setExtendedDesktopSize(n, n2, n3, n4, screenSet);
        if (this.continuousUpdates) {
            this.writer().writeEnableContinuousUpdates(true, 0, 0, this.server.width(), this.server.height());
        }
        this.resizeFramebuffer();
        assert (this.framebuffer != null);
        assert (this.framebuffer.width() == this.server.width());
        assert (this.framebuffer.height() == this.server.height());
    }

    @Override
    public void endOfContinuousUpdates() {
        super.endOfContinuousUpdates();
        if (this.pendingPFChange) {
            this.server.setPF(this.pendingPF);
            this.pendingPFChange = false;
            if (this.formatChange) {
                this.requestNewUpdate();
            }
        }
    }

    @Override
    public void serverInit(int n, int n2, PixelFormat pixelFormat, String string) {
        super.serverInit(n, n2, pixelFormat, string);
        this.state_ = stateEnum.RFBSTATE_NORMAL;
        vlog.debug("Initialisation done", new Object[0]);
        this.initDone();
        assert (this.framebuffer != null);
        assert (this.framebuffer.width() == this.server.width());
        assert (this.framebuffer.height() == this.server.height());
        this.encodingChange = true;
        this.requestNewUpdate();
        if (this.pendingPFChange) {
            this.server.setPF(this.pendingPF);
            this.pendingPFChange = false;
        }
    }

    @Override
    public void readAndDecodeRect(Rect rect, int n, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.decoder.decodeRect(rect, n, modifiablePixelBuffer);
        this.decoder.flush();
    }

    @Override
    public void framebufferUpdateStart() {
        super.framebufferUpdateStart();
        assert (this.framebuffer != null);
        this.pendingUpdate = false;
        this.requestNewUpdate();
    }

    @Override
    public void framebufferUpdateEnd() {
        this.decoder.flush();
        super.framebufferUpdateEnd();
        if (this.pendingPFChange && !this.continuousUpdates) {
            this.server.setPF(this.pendingPF);
            this.pendingPFChange = false;
        }
        if (this.firstUpdate) {
            if (this.server.supportsContinuousUpdates) {
                vlog.info("Enabling continuous updates", new Object[0]);
                this.continuousUpdates = true;
                this.writer().writeEnableContinuousUpdates(true, 0, 0, this.server.width(), this.server.height());
            }
            this.firstUpdate = false;
        }
    }

    @Override
    public void dataRect(Rect rect, int n) {
        this.decoder.decodeRect(rect, n, this.framebuffer);
    }

    public void authSuccess() {
    }

    public void initDone() {
    }

    public void resizeFramebuffer() {
        assert (false);
    }

    public void refreshFramebuffer() {
        this.forceNonincremental = true;
        if (this.continuousUpdates) {
            this.requestNewUpdate();
        }
    }

    public void setPreferredEncoding(int n) {
        if (this.preferredEncoding == n) {
            return;
        }
        this.preferredEncoding = n;
        this.encodingChange = true;
    }

    public int getPreferredEncoding() {
        return this.preferredEncoding;
    }

    public void setCompressLevel(int n) {
        if (this.compressLevel == n) {
            return;
        }
        this.compressLevel = n;
        this.encodingChange = true;
    }

    public void setQualityLevel(int n) {
        if (this.qualityLevel == n) {
            return;
        }
        this.qualityLevel = n;
        this.encodingChange = true;
    }

    public void setPF(PixelFormat pixelFormat) {
        if (this.server.pf().equal(pixelFormat) && !this.formatChange) {
            return;
        }
        this.nextPF = pixelFormat;
        this.formatChange = true;
    }

    public CMsgReader reader() {
        return this.reader_;
    }

    public CMsgWriter writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    boolean isSecure() {
        return this.csecurity != null ? this.csecurity.isSecure() : false;
    }

    public stateEnum state() {
        return this.state_;
    }

    protected void setState(stateEnum stateEnum2) {
        this.state_ = stateEnum2;
    }

    protected void setReader(CMsgReader cMsgReader) {
        this.reader_ = cMsgReader;
    }

    protected void setWriter(CMsgWriter cMsgWriter) {
        this.writer_ = cMsgWriter;
    }

    protected ModifiablePixelBuffer getFramebuffer() {
        return this.framebuffer;
    }

    @Override
    public void fence(int n, int n2, byte[] byArray) {
        super.fence(n, n2, byArray);
        if ((n & Integer.MIN_VALUE) != 0) {
            return;
        }
        n = 0;
        this.writer().writeFence(n, n2, byArray);
    }

    private void requestNewUpdate() {
        if (this.formatChange && !this.pendingPFChange) {
            assert (!this.pendingUpdate || this.continuousUpdates);
            this.pendingPFChange = true;
            this.pendingPF = this.nextPF;
            if (this.continuousUpdates) {
                this.writer().writeEnableContinuousUpdates(false, 0, 0, 0, 0);
            }
            this.writer().writeSetPixelFormat(this.pendingPF);
            if (this.continuousUpdates) {
                this.writer().writeEnableContinuousUpdates(true, 0, 0, this.server.width(), this.server.height());
            }
            this.formatChange = false;
        }
        if (this.encodingChange) {
            this.updateEncodings();
            this.encodingChange = false;
        }
        if (this.forceNonincremental || !this.continuousUpdates) {
            this.pendingUpdate = true;
            this.writer().writeFramebufferUpdateRequest(new Rect(0, 0, this.server.width(), this.server.height()), !this.forceNonincremental);
        }
        this.forceNonincremental = false;
    }

    private void updateEncodings() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.server.supportsLocalCursor) {
            if (!osName.contains("windows")) {
                arrayList.add(-314);
                arrayList.add(1464686180);
            }
            arrayList.add(-239);
            arrayList.add(-240);
        }
        if (this.server.supportsDesktopResize) {
            arrayList.add(-223);
            arrayList.add(-308);
        }
        if (this.server.supportsClientRedirect) {
            arrayList.add(-311);
        }
        arrayList.add(-307);
        arrayList.add(-224);
        arrayList.add(-313);
        arrayList.add(-312);
        if (Decoder.supported(this.preferredEncoding)) {
            arrayList.add(this.preferredEncoding);
        }
        arrayList.add(1);
        for (int i = 255; i >= 0; --i) {
            if (i == this.preferredEncoding || !Decoder.supported(i)) continue;
            arrayList.add(i);
        }
        if (this.compressLevel >= 0 && this.compressLevel <= 9) {
            arrayList.add(-256 + this.compressLevel);
        }
        if (this.qualityLevel >= 0 && this.qualityLevel <= 9) {
            arrayList.add(-32 + this.qualityLevel);
        }
        this.writer().writeSetEncodings(arrayList);
    }

    private void throwAuthFailureException() {
        vlog.debug("state=" + (Object)((Object)this.state()) + ", ver=" + this.server.majorVersion + "." + this.server.minorVersion, new Object[0]);
        String string = this.state() == stateEnum.RFBSTATE_SECURITY_RESULT && !this.server.beforeVersion(3, 8) ? this.is.readString() : "Authentication failure";
        this.state_ = stateEnum.RFBSTATE_INVALID;
        vlog.error(string, new Object[0]);
        throw new AuthFailureException(string);
    }

    public static enum stateEnum {
        RFBSTATE_UNINITIALISED,
        RFBSTATE_PROTOCOL_VERSION,
        RFBSTATE_SECURITY_TYPES,
        RFBSTATE_SECURITY,
        RFBSTATE_SECURITY_RESULT,
        RFBSTATE_INITIALISATION,
        RFBSTATE_NORMAL,
        RFBSTATE_INVALID;

    }
}

