﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ds/DirectoryService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DirectoryService {
namespace Model {
/**
 * <p>Result of a VerifyTrust request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrustResult">AWS
 * API Reference</a></p>
 */
class VerifyTrustResult {
 public:
  AWS_DIRECTORYSERVICE_API VerifyTrustResult() = default;
  AWS_DIRECTORYSERVICE_API VerifyTrustResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DIRECTORYSERVICE_API VerifyTrustResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique Trust ID of the trust relationship that was verified.</p>
   */
  inline const Aws::String& GetTrustId() const { return m_trustId; }
  template <typename TrustIdT = Aws::String>
  void SetTrustId(TrustIdT&& value) {
    m_trustIdHasBeenSet = true;
    m_trustId = std::forward<TrustIdT>(value);
  }
  template <typename TrustIdT = Aws::String>
  VerifyTrustResult& WithTrustId(TrustIdT&& value) {
    SetTrustId(std::forward<TrustIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  VerifyTrustResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trustId;
  bool m_trustIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectoryService
}  // namespace Aws
