﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/neptune/Neptune_EXPORTS.h>
#include <aws/neptune/model/DBInstance.h>
#include <aws/neptune/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Neptune {
namespace Model {
class DescribeDBInstancesResult {
 public:
  AWS_NEPTUNE_API DescribeDBInstancesResult() = default;
  AWS_NEPTUNE_API DescribeDBInstancesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_NEPTUNE_API DescribeDBInstancesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p> An optional pagination token provided by a previous request. If this
   * parameter is specified, the response includes only records beyond the marker, up
   * to the value specified by <code>MaxRecords</code> .</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeDBInstancesResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A list of <a>DBInstance</a> instances.</p>
   */
  inline const Aws::Vector<DBInstance>& GetDBInstances() const { return m_dBInstances; }
  template <typename DBInstancesT = Aws::Vector<DBInstance>>
  void SetDBInstances(DBInstancesT&& value) {
    m_dBInstancesHasBeenSet = true;
    m_dBInstances = std::forward<DBInstancesT>(value);
  }
  template <typename DBInstancesT = Aws::Vector<DBInstance>>
  DescribeDBInstancesResult& WithDBInstances(DBInstancesT&& value) {
    SetDBInstances(std::forward<DBInstancesT>(value));
    return *this;
  }
  template <typename DBInstancesT = DBInstance>
  DescribeDBInstancesResult& AddDBInstances(DBInstancesT&& value) {
    m_dBInstancesHasBeenSet = true;
    m_dBInstances.emplace_back(std::forward<DBInstancesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeDBInstancesResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_marker;
  bool m_markerHasBeenSet = false;

  Aws::Vector<DBInstance> m_dBInstances;
  bool m_dBInstancesHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Neptune
}  // namespace Aws
