﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Request.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace PinpointSMSVoiceV2 {
namespace Model {

/**
 */
class UpdateProtectConfigurationRequest : public PinpointSMSVoiceV2Request {
 public:
  AWS_PINPOINTSMSVOICEV2_API UpdateProtectConfigurationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateProtectConfiguration"; }

  AWS_PINPOINTSMSVOICEV2_API Aws::String SerializePayload() const override;

  AWS_PINPOINTSMSVOICEV2_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier for the protect configuration.</p>
   */
  inline const Aws::String& GetProtectConfigurationId() const { return m_protectConfigurationId; }
  inline bool ProtectConfigurationIdHasBeenSet() const { return m_protectConfigurationIdHasBeenSet; }
  template <typename ProtectConfigurationIdT = Aws::String>
  void SetProtectConfigurationId(ProtectConfigurationIdT&& value) {
    m_protectConfigurationIdHasBeenSet = true;
    m_protectConfigurationId = std::forward<ProtectConfigurationIdT>(value);
  }
  template <typename ProtectConfigurationIdT = Aws::String>
  UpdateProtectConfigurationRequest& WithProtectConfigurationId(ProtectConfigurationIdT&& value) {
    SetProtectConfigurationId(std::forward<ProtectConfigurationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When set to true deletion protection is enabled. By default this is set to
   * false. </p>
   */
  inline bool GetDeletionProtectionEnabled() const { return m_deletionProtectionEnabled; }
  inline bool DeletionProtectionEnabledHasBeenSet() const { return m_deletionProtectionEnabledHasBeenSet; }
  inline void SetDeletionProtectionEnabled(bool value) {
    m_deletionProtectionEnabledHasBeenSet = true;
    m_deletionProtectionEnabled = value;
  }
  inline UpdateProtectConfigurationRequest& WithDeletionProtectionEnabled(bool value) {
    SetDeletionProtectionEnabled(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_protectConfigurationId;
  bool m_protectConfigurationIdHasBeenSet = false;

  bool m_deletionProtectionEnabled{false};
  bool m_deletionProtectionEnabledHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
