﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qconnect/QConnect_EXPORTS.h>
#include <aws/qconnect/model/Status.h>
#include <aws/qconnect/model/VisibilityStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QConnect {
namespace Model {

/**
 * <p>The summary of the AI Guardrail.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/AIGuardrailSummary">AWS
 * API Reference</a></p>
 */
class AIGuardrailSummary {
 public:
  AWS_QCONNECT_API AIGuardrailSummary() = default;
  AWS_QCONNECT_API AIGuardrailSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_QCONNECT_API AIGuardrailSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QCONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the AI Guardrail.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AIGuardrailSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Amazon Q in Connect assistant. Can be either the ID or
   * the ARN. URLs cannot contain the ARN.</p>
   */
  inline const Aws::String& GetAssistantId() const { return m_assistantId; }
  inline bool AssistantIdHasBeenSet() const { return m_assistantIdHasBeenSet; }
  template <typename AssistantIdT = Aws::String>
  void SetAssistantId(AssistantIdT&& value) {
    m_assistantIdHasBeenSet = true;
    m_assistantId = std::forward<AssistantIdT>(value);
  }
  template <typename AssistantIdT = Aws::String>
  AIGuardrailSummary& WithAssistantId(AssistantIdT&& value) {
    SetAssistantId(std::forward<AssistantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.</p>
   */
  inline const Aws::String& GetAssistantArn() const { return m_assistantArn; }
  inline bool AssistantArnHasBeenSet() const { return m_assistantArnHasBeenSet; }
  template <typename AssistantArnT = Aws::String>
  void SetAssistantArn(AssistantArnT&& value) {
    m_assistantArnHasBeenSet = true;
    m_assistantArn = std::forward<AssistantArnT>(value);
  }
  template <typename AssistantArnT = Aws::String>
  AIGuardrailSummary& WithAssistantArn(AssistantArnT&& value) {
    SetAssistantArn(std::forward<AssistantArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Amazon Q in Connect AI Guardrail.</p>
   */
  inline const Aws::String& GetAiGuardrailId() const { return m_aiGuardrailId; }
  inline bool AiGuardrailIdHasBeenSet() const { return m_aiGuardrailIdHasBeenSet; }
  template <typename AiGuardrailIdT = Aws::String>
  void SetAiGuardrailId(AiGuardrailIdT&& value) {
    m_aiGuardrailIdHasBeenSet = true;
    m_aiGuardrailId = std::forward<AiGuardrailIdT>(value);
  }
  template <typename AiGuardrailIdT = Aws::String>
  AIGuardrailSummary& WithAiGuardrailId(AiGuardrailIdT&& value) {
    SetAiGuardrailId(std::forward<AiGuardrailIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the AI Guardrail.</p>
   */
  inline const Aws::String& GetAiGuardrailArn() const { return m_aiGuardrailArn; }
  inline bool AiGuardrailArnHasBeenSet() const { return m_aiGuardrailArnHasBeenSet; }
  template <typename AiGuardrailArnT = Aws::String>
  void SetAiGuardrailArn(AiGuardrailArnT&& value) {
    m_aiGuardrailArnHasBeenSet = true;
    m_aiGuardrailArn = std::forward<AiGuardrailArnT>(value);
  }
  template <typename AiGuardrailArnT = Aws::String>
  AIGuardrailSummary& WithAiGuardrailArn(AiGuardrailArnT&& value) {
    SetAiGuardrailArn(std::forward<AiGuardrailArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the AI Guardrail was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetModifiedTime() const { return m_modifiedTime; }
  inline bool ModifiedTimeHasBeenSet() const { return m_modifiedTimeHasBeenSet; }
  template <typename ModifiedTimeT = Aws::Utils::DateTime>
  void SetModifiedTime(ModifiedTimeT&& value) {
    m_modifiedTimeHasBeenSet = true;
    m_modifiedTime = std::forward<ModifiedTimeT>(value);
  }
  template <typename ModifiedTimeT = Aws::Utils::DateTime>
  AIGuardrailSummary& WithModifiedTime(ModifiedTimeT&& value) {
    SetModifiedTime(std::forward<ModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The visibility status of the AI Guardrail.</p>
   */
  inline VisibilityStatus GetVisibilityStatus() const { return m_visibilityStatus; }
  inline bool VisibilityStatusHasBeenSet() const { return m_visibilityStatusHasBeenSet; }
  inline void SetVisibilityStatus(VisibilityStatus value) {
    m_visibilityStatusHasBeenSet = true;
    m_visibilityStatus = value;
  }
  inline AIGuardrailSummary& WithVisibilityStatus(VisibilityStatus value) {
    SetVisibilityStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the AI Guardrail.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  AIGuardrailSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the AI Guardrail.</p>
   */
  inline Status GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(Status value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline AIGuardrailSummary& WithStatus(Status value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags used to organize, track, or control access for this resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  AIGuardrailSummary& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  AIGuardrailSummary& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_assistantId;
  bool m_assistantIdHasBeenSet = false;

  Aws::String m_assistantArn;
  bool m_assistantArnHasBeenSet = false;

  Aws::String m_aiGuardrailId;
  bool m_aiGuardrailIdHasBeenSet = false;

  Aws::String m_aiGuardrailArn;
  bool m_aiGuardrailArnHasBeenSet = false;

  Aws::Utils::DateTime m_modifiedTime{};
  bool m_modifiedTimeHasBeenSet = false;

  VisibilityStatus m_visibilityStatus{VisibilityStatus::NOT_SET};
  bool m_visibilityStatusHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Status m_status{Status::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace QConnect
}  // namespace Aws
