﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/synthetics/SyntheticsRequest.h>
#include <aws/synthetics/Synthetics_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Synthetics {
namespace Model {

/**
 */
class GetCanaryRequest : public SyntheticsRequest {
 public:
  AWS_SYNTHETICS_API GetCanaryRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetCanary"; }

  AWS_SYNTHETICS_API Aws::String SerializePayload() const override;

  AWS_SYNTHETICS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the canary that you want details for.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetCanaryRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The DryRunId associated with an existing canary’s dry run. You can use this
   * DryRunId to retrieve information about the dry run.</p>
   */
  inline const Aws::String& GetDryRunId() const { return m_dryRunId; }
  inline bool DryRunIdHasBeenSet() const { return m_dryRunIdHasBeenSet; }
  template <typename DryRunIdT = Aws::String>
  void SetDryRunId(DryRunIdT&& value) {
    m_dryRunIdHasBeenSet = true;
    m_dryRunId = std::forward<DryRunIdT>(value);
  }
  template <typename DryRunIdT = Aws::String>
  GetCanaryRequest& WithDryRunId(DryRunIdT&& value) {
    SetDryRunId(std::forward<DryRunIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_dryRunId;
  bool m_dryRunIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Synthetics
}  // namespace Aws
