/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolDataSourceProvider;
import org.jkiss.dbeaver.ext.exasol.ExasolSQLDialect;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolChangeUserPasswordManager;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup;
import org.jkiss.dbeaver.ext.exasol.model.ExasolCurrentUserPrivileges;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSourceInfo;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolExecutionContext;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriority;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriorityGroup;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolStructureAssistant;
import org.jkiss.dbeaver.ext.exasol.model.ExasolVirtualSchema;
import org.jkiss.dbeaver.ext.exasol.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.exasol.model.app.ExasolServerSessionManager;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolDataTypeCache;
import org.jkiss.dbeaver.ext.exasol.model.plan.ExasolQueryPlanner;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolBaseObjectGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolConnectionGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolRole;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolRoleGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSchemaGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolScriptGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSecurityPolicy;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSystemGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolTableGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolTableObjectType;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolUser;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolViewGrant;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolDataSource
extends JDBCDataSource
implements IAdaptable {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    private DBSObjectCache<ExasolDataSource, ExasolSchema> schemaCache;
    private DBSObjectCache<ExasolDataSource, ExasolVirtualSchema> virtualSchemaCache;
    private ExasolCurrentUserPrivileges exasolCurrentUserPrivileges;
    private DBSObjectCache<ExasolDataSource, ExasolUser> userCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolRole> roleCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolConnection> connectionCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolPriorityGroup> priorityGroupCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolConsumerGroup> consumerGroupCache = null;
    private ExasolDataTypeCache dataTypeCache = new ExasolDataTypeCache();
    private DBSObjectCache<ExasolDataSource, ExasolRoleGrant> roleGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolSystemGrant> systemGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolConnectionGrant> connectionGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolBaseObjectGrant> baseTableGrantCache = null;
    private DBSObjectCache<ExasolDataSource, ExasolSecurityPolicy> securityPolicyCache = null;
    private Properties addMetaProps = new Properties();
    private int driverMajorVersion = 5;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("(.+)\\[line ([0-9]+), column ([0-9]+)\\]");

    public ExasolDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new ExasolSQLDialect());
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                this.exasolCurrentUserPrivileges = new ExasolCurrentUserPrivileges(monitor, session, this);
                this.driverMajorVersion = session.getMetaData().getDriverMajorVersion();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error reading active schema", (Throwable)e);
        }
        Object schemaSQL = "/*snapshot execution*/ select schema_name as object_name,schema_owner as OWNER,CAST(NULL AS TIMESTAMP) AS created, schema_comment as OBJECT_COMMENT, SCHEMA_OBJECT_ID from SYS.EXA_SCHEMAS s  ";
        if (this.exasolCurrentUserPrivileges.getAtLeastV6().booleanValue()) {
            schemaSQL = (String)schemaSQL + " where not  schema_is_virtual ";
            String vsAdapterExpressionV8 = "'\"' || ADAPTER_SCRIPT_SCHEMA || '\".\"' || ADAPTER_SCRIPT_NAME || '\"' AS ADAPTER_SCRIPT";
            this.virtualSchemaCache = new JDBCObjectSimpleCache(ExasolVirtualSchema.class, "/*snapshot execution*/ select\ts.SCHEMA_NAME as OBJECT_NAME,\ts.SCHEMA_OWNER AS OWNER,CAST(NULL AS TIMESTAMP) AS created, \t" + (this.exasolCurrentUserPrivileges.getAtLeastV8() != false ? vsAdapterExpressionV8 : "ADAPTER_SCRIPT") + ",\tLAST_REFRESH,\tLAST_REFRESH_BY,\tADAPTER_NOTES,\tSCHEMA_COMMENT AS OBJECT_COMMENT, s.SCHEMA_OBJECT_ID from\t\tEXA_VIRTUAL_SCHEMAS s\tINNER JOIN\t\tsys.EXA_SCHEMAS o\tON\t\to.schema_name = s.SCHEMA_NAME ORDER BY S.SCHEMA_NAME", new Object[0]);
        }
        schemaSQL = (String)schemaSQL + " union all select distinct SCHEMA_NAME as \"OBJECT_NAME\", 'SYS' as owner, cast(null as timestamp) as created, '' as \"OBJECT_COMMENT\", null as SCHEMA_OBJECT_ID from SYS.EXA_SYSCAT order by object_name";
        this.schemaCache = new JDBCObjectSimpleCache(ExasolSchema.class, (String)schemaSQL, new Object[0]);
        try {
            this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBException e) {
            LOG.warn((Object)"Error reading types info", (Throwable)e);
            this.dataTypeCache.setCache(Collections.emptyList());
        }
        String priorityColUser = " USER_PRIORITY,\n";
        String priorityColRole = " ROLE_PRIORITY AS USER_PRIORITY,\n";
        if (this.exasolCurrentUserPrivileges.hasConsumerGroups().booleanValue()) {
            priorityColUser = " USER_CONSUMER_GROUP as USER_PRIORITY,\n";
            priorityColRole = " ROLE_CONSUMER_GROUP AS USER_PRIORITY,\n";
        }
        this.userCache = new JDBCObjectSimpleCache(ExasolUser.class, "/*snapshot execution*/ SELECT\n\tUSER_NAME,\n\tCREATED,\n" + (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess() != false ? "\tDISTINGUISHED_NAME,\n" : "") + (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess() != false ? "\tKERBEROS_PRINCIPAL,\n" : "") + (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess() != false ? "\tPASSWORD,\n" : "") + priorityColUser + "\tPASSWORD_STATE,\n\tPASSWORD_STATE_CHANGED,\n\tPASSWORD_EXPIRY,\n\tPASSWORD_EXPIRY_DAYS,\n\tPASSWORD_GRACE_DAYS,\n\tPASSWORD_EXPIRY_POLICY,\n\tFAILED_LOGIN_ATTEMPTS,\n\tUSER_COMMENT\nFROM SYS." + this.exasolCurrentUserPrivileges.getTablePrefix(ExasolSysTablePrefix.USER) + "_USERS ORDER BY USER_NAME", new Object[0]);
        this.roleCache = new JDBCObjectSimpleCache(ExasolRole.class, "SELECT ROLE_NAME,CREATED," + priorityColRole + " ROLE_COMMENT FROM SYS." + this.exasolCurrentUserPrivileges.getTablePrefix(ExasolSysTablePrefix.SESSION) + "_ROLES ORDER BY ROLE_NAME", new Object[0]);
        this.connectionCache = new JDBCObjectSimpleCache(ExasolConnection.class, "/*snapshot execution*/ SELECT * FROM SYS." + this.exasolCurrentUserPrivileges.getTablePrefix(ExasolSysTablePrefix.SESSION) + "_CONNECTIONS ORDER BY CONNECTION_NAME", new Object[0]);
        if (this.exasolCurrentUserPrivileges.hasPasswordPolicy().booleanValue()) {
            this.securityPolicyCache = new JDBCObjectSimpleCache(ExasolSecurityPolicy.class, "/*snapshot execution*/ SELECT SYSTEM_VALUE FROM sys.EXA_PARAMETERS WHERE PARAMETER_NAME = 'PASSWORD_SECURITY_POLICY'", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.hasConsumerGroups().booleanValue()) {
            this.consumerGroupCache = new JDBCObjectSimpleCache(ExasolConsumerGroup.class, "/*snapshot execution*/ SELECT\nCONSUMER_GROUP_NAME,\nCONSUMER_GROUP_ID,\nPRECEDENCE,\nCPU_WEIGHT,\nGROUP_TEMP_DB_RAM_LIMIT,\nUSER_TEMP_DB_RAM_LIMIT,\nSESSION_TEMP_DB_RAM_LIMIT,\nCREATED,\nCONSUMER_GROUP_COMMENT\nFROM\nsys.EXA_CONSUMER_GROUPS ecg\n", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.hasPriorityGroups().booleanValue()) {
            this.priorityGroupCache = new JDBCObjectSimpleCache(ExasolPriorityGroup.class, "/*snapshot execution*/ SELECT * FROM SYS.EXA_PRIORITY_GROUPS ORDER BY PRIORITY_GROUP_NAME", new Object[0]);
        } else {
            this.priorityGroupCache = new DBSObjectCache<ExasolDataSource, ExasolPriorityGroup>(){
                List<ExasolPriorityGroup> groups;

                public void setCache(@NotNull List<ExasolPriorityGroup> objects) {
                }

                public void removeObject(@NotNull ExasolPriorityGroup object, boolean resetFullCache) {
                }

                public void renameObject(@NotNull ExasolPriorityGroup object, @NotNull String oldName, @NotNull String newName) {
                }

                public boolean isFullyCached() {
                    return true;
                }

                public ExasolPriorityGroup getObject(@NotNull DBRProgressMonitor monitor, @NotNull ExasolDataSource owner, @NotNull String name) {
                    return this.getCachedObject(name);
                }

                @NotNull
                public List<ExasolPriorityGroup> getCachedObjects() {
                    return this.groups;
                }

                public ExasolPriorityGroup getCachedObject(@NotNull String name) {
                    for (ExasolPriorityGroup p : this.groups) {
                        if (!p.getName().equals(name)) continue;
                        return p;
                    }
                    return null;
                }

                @NotNull
                public Collection<ExasolPriorityGroup> getAllObjects(@NotNull DBRProgressMonitor monitor, ExasolDataSource owner) throws DBException {
                    this.groups = new ArrayList<ExasolPriorityGroup>();
                    this.groups.add(new ExasolPriorityGroup(owner, "HIGH", "Default High Group", 900));
                    this.groups.add(new ExasolPriorityGroup(owner, "MEDIUM", "Default Medium Group", 900));
                    this.groups.add(new ExasolPriorityGroup(owner, "LOW", "Default LOW Group", 900));
                    return this.groups;
                }

                public void clearCache() {
                    this.groups = new ArrayList<ExasolPriorityGroup>();
                }

                public void cacheObject(@NotNull ExasolPriorityGroup object) {
                }
            };
            this.priorityGroupCache.getAllObjects(monitor, (DBSObject)this);
        }
        if (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess().booleanValue()) {
            this.connectionGrantCache = new JDBCObjectSimpleCache(ExasolConnectionGrant.class, "/*snapshot execution*/ SELECT c.*,P.ADMIN_OPTION,P.GRANTEE FROM SYS.EXA_DBA_CONNECTION_PRIVS P INNER JOIN SYS.EXA_DBA_CONNECTIONS C on P.GRANTED_CONNECTION = C.CONNECTION_NAME ORDER BY P.GRANTEE,C.CONNECTION_NAME ", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess().booleanValue()) {
            this.baseTableGrantCache = new JDBCObjectSimpleCache(ExasolBaseObjectGrant.class, "/*snapshot execution*/ SELECT \tOBJECT_SCHEMA,\tOBJECT_TYPE,\tGRANTEE,\tOBJECT_NAME,\tGROUP_CONCAT(\t\tDISTINCT PRIVILEGE\tORDER BY\t\tOBJECT_SCHEMA,\t\tOBJECT_NAME\t\tSEPARATOR '|'\t) as PRIVS  FROM\tSYS.EXA_DBA_OBJ_PRIVS P GROUP BY\tOBJECT_SCHEMA,\tOBJECT_TYPE,\tGRANTEE,\tOBJECT_NAME ORDER BY GRANTEE,OBJECT_SCHEMA,OBJECT_TYPE,OBJECT_NAME", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess().booleanValue()) {
            this.systemGrantCache = new JDBCObjectSimpleCache(ExasolSystemGrant.class, "/*snapshot execution*/ SELECT GRANTEE,PRIVILEGE,ADMIN_OPTION FROM SYS.EXA_DBA_SYS_PRIVS ORDER BY GRANTEE,PRIVILEGE", new Object[0]);
        }
        if (this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess().booleanValue()) {
            this.roleGrantCache = new JDBCObjectSimpleCache(ExasolRoleGrant.class, "/*snapshot execution*/ select r.*,p.ADMIN_OPTION,p.GRANTEE from EXA_DBA_ROLES r INNER JOIN  EXA_DBA_ROLE_PRIVS p ON p.GRANTED_ROLE = r.ROLE_NAME ORDER BY P.GRANTEE,R.ROLE_NAME", new Object[0]);
        }
    }

    int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @NotNull
    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties props = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        if (this.addMetaProps == null) {
            this.addMetaProps = new Properties();
        }
        this.addMetaProps.clear();
        return props;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        while (error instanceof DBException) {
            if (error.getCause() == null) {
                return null;
            }
            error = error.getCause();
        }
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message)) {
            Matcher matcher = this.ERROR_POSITION_PATTERN.matcher(message);
            ArrayList<DBPErrorAssistant.ErrorPosition> positions = new ArrayList<DBPErrorAssistant.ErrorPosition>();
            while (matcher.find()) {
                DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                pos.info = matcher.group(1);
                pos.line = Integer.parseInt(matcher.group(2)) - 1;
                pos.position = Integer.parseInt(matcher.group(3)) - 1;
                positions.add(pos);
            }
            if (!positions.isEmpty()) {
                return positions.toArray(new DBPErrorAssistant.ErrorPosition[0]);
            }
        }
        return null;
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new ExasolExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        if (initFrom != null) {
            ((ExasolExecutionContext)context).setCurrentSchema(monitor, ((ExasolExecutionContext)initFrom).getDefaultSchema());
        } else {
            ((ExasolExecutionContext)context).refreshDefaults(monitor, true);
        }
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new ExasolStructureAssistant(this));
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new ExasolServerSessionManager(this));
        }
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new ExasolChangeUserPasswordManager(this));
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new ExasolQueryPlanner(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        ExasolDataSourceInfo info = new ExasolDataSourceInfo(metaData);
        info.setSupportsResultSetScroll(false);
        return info;
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>(ExasolDataSourceProvider.getConnectionsProps());
        if (CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("exasol.useLegacyEncryption"), (boolean)false)) {
            props.put("legacyencryption", "1");
        }
        return props;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.schemaCache.clearCache();
        this.connectionCache.clearCache();
        this.userCache.clearCache();
        if (this.roleCache != null) {
            this.roleCache.clearCache();
        }
        if (this.baseTableGrantCache != null) {
            this.baseTableGrantCache.clearCache();
        }
        if (this.systemGrantCache != null) {
            this.systemGrantCache.clearCache();
        }
        if (this.connectionGrantCache != null) {
            this.connectionGrantCache.clearCache();
        }
        return this;
    }

    @NotNull
    public Class<? extends ExasolSchema> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return ExasolSchema.class;
    }

    public Collection<ExasolSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public ExasolSchema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (this.exasolCurrentUserPrivileges.getAtLeastV6().booleanValue()) {
            return this.getSchema(monitor, childName) != null ? this.getSchema(monitor, childName) : this.getVirtualSchema(monitor, childName);
        }
        return this.getSchema(monitor, childName);
    }

    @Association
    public Collection<ExasolSchema> getSchemas(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolVirtualSchema> getVirtualSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.virtualSchemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolVirtualSchema getVirtualSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolVirtualSchema)this.virtualSchemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public Collection<ExasolGrantee> getAllGrantees(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolGrantee> grantees = new ArrayList<ExasolGrantee>();
        grantees.addAll(this.getUsers(monitor));
        grantees.addAll(this.getRoles(monitor));
        return grantees;
    }

    @Association
    public Collection<ExasolUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolRole getRole(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolRole)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolPriorityGroup> getPriorityGroups(DBRProgressMonitor monitor) throws DBException {
        return this.priorityGroupCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<ExasolConsumerGroup> getConsumerGroups(DBRProgressMonitor monitor) throws DBException {
        return this.consumerGroupCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolPriorityGroup getPriorityGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolPriorityGroup)this.priorityGroupCache.getObject(monitor, (DBSObject)this, name);
    }

    public ExasolPriority getConsumGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolPriority)this.consumerGroupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<ExasolSecurityPolicy> getSecurityPolicies(DBRProgressMonitor monitor) throws DBException {
        return this.securityPolicyCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolSecurityPolicy getSecurityPolicy(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolSecurityPolicy)this.securityPolicyCache.getCachedObject(name);
    }

    @Association
    public Collection<ExasolConnection> getConnections(DBRProgressMonitor monitor) throws DBException {
        return this.connectionCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolConnection getConnection(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolConnection)this.connectionCache.getObject(monitor, (DBSObject)this, name);
    }

    public DBSObjectCache<ExasolDataSource, ExasolConsumerGroup> getConsumerGroupCache() {
        return this.consumerGroupCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolPriorityGroup> getPriorityGroupCache() {
        return this.priorityGroupCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolSecurityPolicy> getSecurityPolicyCache() {
        return this.securityPolicyCache;
    }

    @Association
    public Collection<ExasolBaseObjectGrant> getBaseTableGrants(DBRProgressMonitor monitor) throws DBException {
        return this.baseTableGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolTableGrant> getTableGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableGrant> grants = new ArrayList<ExasolTableGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.TABLE) continue;
            grants.add(new ExasolTableGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolViewGrant> getViewGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolViewGrant> grants = new ArrayList<ExasolViewGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.VIEW) continue;
            grants.add(new ExasolViewGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolScriptGrant> getScriptGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolScriptGrant> grants = new ArrayList<ExasolScriptGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.SCRIPT) continue;
            grants.add(new ExasolScriptGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolSchemaGrant> getSchemaGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSchemaGrant> grants = new ArrayList<ExasolSchemaGrant>();
        for (ExasolBaseObjectGrant grant : this.getBaseTableGrants(monitor)) {
            if (grant.getType() != ExasolTableObjectType.SCHEMA) continue;
            grants.add(new ExasolSchemaGrant(grant));
        }
        return grants;
    }

    public Collection<ExasolConnectionGrant> getConnectionGrants(DBRProgressMonitor monitor) throws DBException {
        return this.connectionGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolSystemGrant> getSystemGrants(DBRProgressMonitor monitor) throws DBException {
        return this.systemGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<ExasolRoleGrant> getRoleGrants(DBRProgressMonitor monitor) throws DBException {
        return this.roleGrantCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<ExasolDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolDataType getDataType(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolDataType)this.dataTypeCache.getObject(monitor, (DBSObject)this, name);
    }

    public ExasolDataType getDataTypeId(long id) {
        return this.dataTypeCache.getDataTypeId(id);
    }

    public Boolean hasAlterUserPrivilege() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isAuthorizedForUsers() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isAuthorizedForConnections() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isAuthorizedForRoles() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isAuthorizedForRolePrivs() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isUserAuthorizedForSessions() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isatLeastV6() {
        return this.exasolCurrentUserPrivileges.getAtLeastV6();
    }

    public boolean isatLeastV5() {
        return this.exasolCurrentUserPrivileges.getAtLeastV5();
    }

    public boolean ishasPartitionColumns() {
        return this.exasolCurrentUserPrivileges.hasPartitionColumns();
    }

    public boolean ishasConsumerGroups() {
        return this.exasolCurrentUserPrivileges.hasConsumerGroups();
    }

    public boolean ishasPasswordPolicy() {
        return this.exasolCurrentUserPrivileges.hasPasswordPolicy();
    }

    public boolean ishasPriorityGroups() {
        return this.exasolCurrentUserPrivileges.hasPriorityGroups();
    }

    public boolean isAuthorizedForConnectionPrivs() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public boolean isAuthorizedForObjectPrivs() {
        return this.exasolCurrentUserPrivileges.getUserHasDictionaryAccess();
    }

    public DBSObjectCache<ExasolDataSource, ExasolConnection> getConnectionCache() {
        return this.connectionCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolUser> getUserCache() {
        return this.userCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolRole> getRoleCache() {
        return this.roleCache;
    }

    public DBSObjectCache<ExasolDataSource, ExasolSchema> getSchemaCache() {
        return this.schemaCache;
    }

    @NotNull
    public Collection<? extends DBSDataType> getLocalDataTypes() {
        try {
            return this.getDataTypes((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            LOG.error((Object)"DBException occured when reading system dataTypes: ", (Throwable)e);
            return null;
        }
    }

    public String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        Object querytimeout;
        Object propClientName;
        Object port = ":8563";
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            port = ":" + connectionInfo.getHostPort();
        }
        Map properties = connectionInfo.getProperties();
        StringBuilder url = new StringBuilder(128);
        url.append("jdbc:exa:").append(connectionInfo.getHostName()).append((String)port);
        String backupHostList = connectionInfo.getProviderProperty("@dbeaver-backupHostList");
        if (!CommonUtils.isEmpty((String)backupHostList)) {
            url.append(",").append(backupHostList).append((String)port);
        }
        if (!url.toString().toUpperCase().contains("CLIENTNAME")) {
            Object clientName = Platform.getProduct().getName();
            propClientName = properties.get("clientname");
            if (propClientName != null) {
                clientName = propClientName.toString();
            }
            if (!this.addMetaProps.isEmpty()) {
                clientName = (String)clientName + "-Meta";
            }
            url.append(";clientname=").append((String)clientName);
        }
        if (!url.toString().toUpperCase().contains("CLIENTVERSION")) {
            String clientVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
            propClientName = properties.get("clientversion");
            if (propClientName != null) {
                clientVersion = propClientName.toString();
            }
            url.append(";clientversion=").append(clientVersion);
        }
        if ((querytimeout = properties.get("querytimeout")) != null) {
            url.append(";").append("querytimeout").append("=").append(querytimeout);
        }
        if (!this.addMetaProps.isEmpty()) {
            Set<Map.Entry<Object, Object>> entries = this.addMetaProps.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                url.append(";").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return url.toString();
    }

    @Nullable
    public DBSDataType getLocalDataType(String typeName) {
        try {
            return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName);
        }
        catch (DBException e) {
            LOG.error((Object)("DBException occured when reading system dataType: " + typeName), (Throwable)e);
            return null;
        }
    }

    DBSObjectCache<ExasolDataSource, ExasolDataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    public ExasolCurrentUserPrivileges getUserPriviliges() {
        return this.exasolCurrentUserPrivileges;
    }

    public String getTablePrefix(ExasolSysTablePrefix fallback) {
        return this.exasolCurrentUserPrivileges.getTablePrefix(fallback);
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false);
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll();
        }
        return super.createQueryTransformer(type);
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        String errorMessage = error.getMessage();
        if (errorMessage.contains("Feature not supported")) {
            return DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED;
        }
        if (errorMessage.contains("insufficient privileges")) {
            return DBPErrorAssistant.ErrorType.PERMISSION_DENIED;
        }
        if (errorMessage.contains("Connection lost") | errorMessage.contains("Connection was killed") | errorMessage.contains("Process does not exist") | errorMessage.contains("Successfully reconnected") | errorMessage.contains("Statement handle not found") | errorMessage.contains("No operations allowed on this connection because it was already closed") | errorMessage.contains("Connection was lost and could not be reestablished")) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return super.discoverErrorType(error);
    }
}

