/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.memory.ChatMemory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.plugin.ai.chat.LiveChatSession;
import org.freeplane.plugin.ai.chat.LiveChatSessionId;
import org.freeplane.plugin.ai.chat.LiveChatSessionSummary;

final class LiveChatSessionManager {
    private final Map<LiveChatSessionId, LiveChatSession> sessions = new LinkedHashMap<LiveChatSessionId, LiveChatSession>();
    private LiveChatSessionId currentSessionId;

    LiveChatSessionManager() {
    }

    LiveChatSession createSession(ChatMemory chatMemory, String displayName) {
        LiveChatSessionId id = LiveChatSessionId.create();
        LiveChatSession session = new LiveChatSession(id, chatMemory, displayName);
        session.setLastActivityTimestamp(System.currentTimeMillis());
        this.sessions.put(id, session);
        if (this.currentSessionId == null) {
            this.currentSessionId = id;
        }
        return session;
    }

    LiveChatSession getCurrentSession() {
        return this.currentSessionId == null ? null : this.sessions.get(this.currentSessionId);
    }

    LiveChatSessionId getCurrentSessionId() {
        return this.currentSessionId;
    }

    void setCurrentSession(LiveChatSessionId sessionId) {
        if (sessionId == null || !this.sessions.containsKey(sessionId)) {
            return;
        }
        this.currentSessionId = sessionId;
    }

    List<LiveChatSessionSummary> listSessions() {
        ArrayList<LiveChatSessionSummary> summaries = new ArrayList<LiveChatSessionSummary>();
        for (LiveChatSession session : this.sessions.values()) {
            if (session.getTranscriptEntries().isEmpty()) continue;
            summaries.add(new LiveChatSessionSummary(session.getId(), session.getDisplayName(), new ArrayList<String>(session.getMapIds()), session.getMapRootShortTextCounts(), session.getTranscriptId(), session.getLastActivityTimestamp()));
        }
        return summaries;
    }

    void rename(LiveChatSessionId sessionId, String displayName) {
        LiveChatSession session = this.sessions.get(sessionId);
        if (session == null || displayName == null) {
            return;
        }
        session.setDisplayName(displayName);
        session.setNameEdited(true);
    }

    LiveChatSession remove(LiveChatSessionId sessionId) {
        LiveChatSession removed = this.sessions.remove(sessionId);
        if (sessionId != null && sessionId.equals(this.currentSessionId)) {
            this.currentSessionId = this.sessions.isEmpty() ? null : this.sessions.keySet().iterator().next();
        }
        return removed;
    }

    LiveChatSession findSession(LiveChatSessionId sessionId) {
        return this.sessions.get(sessionId);
    }

    void recordMapId(String mapId) {
        LiveChatSession session = this.getCurrentSession();
        if (session == null || mapId == null || mapId.isEmpty()) {
            return;
        }
        session.getMapIds().add(mapId);
        session.setLastActivityTimestamp(System.currentTimeMillis());
    }

    void updateUserMessageName(String updatedName) {
        LiveChatSession session = this.getCurrentSession();
        if (session == null || session.isNameEdited() || session.isUserMessageNameApplied()) {
            return;
        }
        session.setDisplayName(updatedName);
        session.setUserMessageNameApplied(true);
    }
}

