/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type DOMNode } from './dom.js';
import { type TextFragment } from './measure-element.js';
export type LayoutState = Record<string, any>;
export type LayoutCallbacks<T extends LayoutState> = {
    onText: (fragment: TextFragment, state: T) => void;
    onNewline: (count: number, state: T) => void;
    onSpace: (count: number, state: T) => void;
    initialState: () => T;
};
export declare const processLayout: <T extends LayoutState>(node: DOMNode, callbacks: LayoutCallbacks<T>) => {
    state: T;
    lineBottom: number;
};
