---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 単一の集中管理された場所から、複数のグループやプロジェクトにセキュリティポリシーを適用する方法について説明します。
title: ポリシーの適用
---

各プロジェクトまたはグループに対して新しいセキュリティポリシーを作成できますが、複数のトップレベルグループに同じ設定を複製すると、時間がかかり、コンプライアンス上の課題が生じる可能性があります。セキュリティポリシーを作成する前に、セキュリティポリシーが次のいずれである必要があるかを知っておく必要があります:

- 特定のプロジェクトまたはグループで適用される。
- 複数のプロジェクトで適用する。
- インスタンス全体またはトップレベルグループ全体で適用される

複数の方法でセキュリティポリシーを適用できます:

- 単一のプロジェクトまたはグループ内のすべてのプロジェクトにセキュリティポリシーを適用するには、そのプロジェクトまたはグループでセキュリティポリシーを作成します。
- 複数のプロジェクトにわたってポリシーを適用するには、[セキュリティポリシープロジェクト](security_policy_projects.md)を使用します。セキュリティポリシープロジェクトは、ポリシーのみを格納するための特別なタイプのプロジェクトです。セキュリティポリシープロジェクトのポリシーを他のグループやプロジェクトに適用するには、グループまたは他のプロジェクトからセキュリティポリシープロジェクトにリンクします。
- セキュリティポリシーとコンプライアンスフレームワークをSelf-Managedインスタンス全体でまとめて適用するために、インスタンス管理者は[コンプライアンスおよびセキュリティポリシー管理グループ](compliance_and_security_policy_groups.md)を使用できます。

## ポリシー設計ガイドライン {#policy-design-guidelines}

ポリシーを設計するときの目標は次のとおりです:

- 適用した際に最小限のオーバーヘッドで最大限のカバレッジが得られるようにポリシーの適用戦略を設計する
- 職務分離を確保する

### 適用 {#enforcement}

要件を満たすようにポリシーを適用するには、次の要素を考慮します:

- **Inheritance**（継承）: デフォルトでは、ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。
- **スコープ**: 要件に合わせてポリシーのスコープを定義し、ポリシーの適用をカスタマイズできます。

#### 継承 {#inheritance}

ポリシーのカバレッジを最大化するには、目標達成が求められる最上位の組織単位（グループ、サブグループ、またはプロジェクト）にセキュリティポリシープロジェクトをリンクします。ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。最上位の組織単位に適用することで、必要なセキュリティポリシーの数を最小限に抑え、管理のオーバーヘッドを削減できます。

ポリシーの継承を使用して、ポリシーを段階的にロールアウトできます。たとえば、新しいポリシーをロールアウトする場合、1つのプロジェクトにそのポリシーを適用し、テストを実施できます。テストに成功したら、そのポリシーをプロジェクトから削除し、次にグループに適用するといった具合に階層を上げていき、最終的にすべての該当プロジェクトに適用します。

既存のグループまたはサブグループに適用されるポリシーは、その下に新しく作成されたサブグループとプロジェクトにも自動的に適用されます。ただし、以下のすべての条件を満たす場合に限ります:

- 新しいサブグループおよびプロジェクトがポリシーのスコープ定義に含まれている（たとえば、スコープにこのグループのすべてのプロジェクトが含まれている）。
- 既存のグループまたはサブグループがすでにセキュリティポリシープロジェクトにリンクされている。

{{< alert type="note" >}}

GitLab.comユーザーは、自分のトップレベルグループまたはサブグループ全体にポリシーを適用できますが、GitLab.comの複数のトップレベルグループにまたがってポリシーを適用することはできません。GitLab Self-Managed管理者は、インスタンス内の複数のトップレベルグループにまたがってポリシーを適用できます。

{{< /alert >}}

次の例は、2つのグループとその構造を示しています:

- Alphaグループには2つのサブグループが含まれており、各サブグループには複数のプロジェクトが含まれています。
- セキュリティとコンプライアンスグループには2つのポリシーが含まれています。

**Alpha**グループ（コードプロジェクトを含む）

- **Finance**（サブグループ）
  - プロジェクトA
  - 受取勘定（サブグループ）
    - プロジェクトB
    - プロジェクトC
- **Engineering**（サブグループ）
  - プロジェクトK
  - プロジェクトL
  - プロジェクトM

**セキュリティとコンプライアンス**グループ（セキュリティポリシープロジェクトを含む）

- セキュリティポリシー管理
- セキュリティポリシー管理 - セキュリティポリシープロジェクト
  - SASTポリシー
  - シークレット検出ポリシー

ポリシーが適用されていないと仮定して、次の例を考えてみましょう:

- 「SAST」ポリシーがグループAlphaに適用されている場合、そのサブグループである財務とエンジニアリング、およびそれらのすべてのプロジェクトとサブグループに適用されます。「シークレット検出」ポリシーがサブグループ「受取勘定」でも適用されている場合、SASTとシークレット検出両方のポリシーがプロジェクトBとCに適用されます。ただし、プロジェクトAには「SAST」ポリシーのみが適用されます。
- 「SAST」ポリシーがサブグループ「受取勘定」に適用されている場合、プロジェクトBとCのみに適用されます。プロジェクトAにはポリシーは適用されません。
- 「シークレット検出」ポリシーがプロジェクトKで適用されている場合、プロジェクトKのみに適用されます。他のサブグループまたはプロジェクトにはポリシーは適用されません。

#### スコープ {#scope}

{{< history >}}

- GitLab 16.7で、`security_policies_policy_scope`[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135398)されました。デフォルトでは有効になっています。
- GitLab 16.11で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/443594)になりました。機能フラグ`security_policies_policy_scope`は削除されました。
- グループによるスコーピングは、GitLab 17.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/468384)されました。

{{< /history >}}

ポリシーのスコープは、次の方法で絞り込むことができます:

- コンプライアンスフレームワーク: 選択したコンプライアンスフレームワークを持つプロジェクトにポリシーを適用します。
- グループ:
  - グループ内のすべてのプロジェクト。すべての子孫サブグループとそのプロジェクトを含みます。オプションで、特定のプロジェクトを除外できます。
  - 複数のグループ内のすべてのプロジェクト。それらの子孫サブグループとそのプロジェクトを含みます。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。オプションで、特定のプロジェクトを除外できます。
- プロジェクト: 特定のプロジェクトを含めるか除外します。同じセキュリティポリシープロジェクトにリンクされているプロジェクトのみ、ポリシーの対象として列挙できます。

これらのオプションは、同じポリシー内で組み合わせて使用​​できます。ただし、除外が包含よりも優先されます。

## 職務分離 {#separation-of-duties}

ポリシーの正常な実装のためには、職務分離が不可欠です。必要なコンプライアンス要件とセキュリティ要件を満たすポリシーを実装すると同時に、開発チームが目標を達成できるようにします。

セキュリティチームとコンプライアンスチーム:

- ポリシーの定義を担当し、開発チームと協力してポリシーが開発チームの要件を満たすようにする必要があります。

開発チーム:

- いかなる方法でもポリシーを無効化、変更、または回避できないようにする必要があります。

グループ、サブグループ、またはプロジェクトでセキュリティポリシープロジェクトを適用するには、次のいずれかが必要です:

- そのグループ、サブグループ、またはプロジェクトにおけるオーナーロール。
- そのグループ、サブグループ、またはプロジェクトにおける`manage_security_policy_link`権限を持つ[カスタムロール](../../../custom_roles/_index.md)。

オーナーロール、および`manage_security_policy_link`権限を持つカスタムロールは、グループ、サブグループ、プロジェクト全体で標準の階層ルールに従います:

| 組織単位 | グループオーナーまたはグループの`manage_security_policy_link`権限 | サブグループオーナーまたはサブグループの`manage_security_policy_link`権限 | プロジェクトオーナーまたはプロジェクトの`manage_security_policy_link`権限 |
|-------------------|---------------------------------------------------------------|---------------------------------------------------------------------|-------------------------------------------------------------------|
| グループ             | {{< icon name="check-circle" >}}適用                                        | {{< icon name="dotted-circle" >}}対象外                                              | {{< icon name="dotted-circle" >}}対象外                                            |
| サブグループ          | {{< icon name="check-circle" >}}適用                                        | {{< icon name="check-circle" >}}対応                                              | {{< icon name="dotted-circle" >}}対象外                                            |
| プロジェクト           | {{< icon name="check-circle" >}}適用                                        | {{< icon name="check-circle" >}}対応                                              | {{< icon name="check-circle" >}}対応                                            |
