---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: コンプライアンスステータスレポート
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.11で`enable_standards_adherence_dashboard_v2`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186525)されました。デフォルトでは有効になっています。
- GitLab 18.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/535563)になりました。機能フラグ`enable_standards_adherence_dashboard_v2`は削除されました。

{{< /history >}}

このコンプライアンスフレームワークステータスレポートには、プロジェクトが[コンプライアンスフレームワークの要件](../compliance_frameworks/_index.md#requirements)を遵守していない最新のインスタンスが表示されます。これはコンプライアンスセンターの一部であり、プロジェクト全体のコントロール実装におけるギャップを迅速に特定し、修正するのに役立ちます。

## スキャンのタイミングとトリガー {#scan-timing-and-triggers}

ステータスレポートを更新するコンプライアンススキャンは、次の状況で自動的にトリガーされます:

- フレームワークがプロジェクトに追加された。
- 関連付けられたフレームワークの要件が変更された。
- スケジュールされたスキャンが実行される（12時間ごと）。

スキャンがトリガーされた後、コンプライアンスステータスレポートに結果が表示されるまでに5〜10分かかることがあります。

コンプライアンスフレームワークで要件とコントロールがどのように定義されているかについて詳しくは、[コンプライアンスフレームワークの要件の作成と管理](../compliance_frameworks/_index.md#add-requirements)をご覧ください。

## コンプライアンスステータスレポートを表示します {#view-the-compliance-status-report}

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

コンプライアンスステータスレポートを表示するには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ** > **コンプライアンスセンター**を選択します。
1. **Compliance reports**（コンプライアンスレポート）セクションで、**Compliance status report**（コンプライアンスステータスレポート）を選択します。

## レポートの詳細 {#report-details}

コンプライアンスステータスレポートには、プロジェクトがフレームワークコントロールを遵守しているか、遵守していない最新のインスタンスが表示されます。各行には、特定のプロジェクトにおけるコントロールの現在のステータスに関する詳細が示され、グループ全体のコンプライアンスを監視するのに役立ちます。

次のことができます: 

- プロジェクト、フレームワーク、またはコントロールでレポートをフィルタリングします。
- プロジェクトのコンプライアンス詳細ビューに直接移動します。
- 不遵守が最初に検出された時期を確認します。

コンプライアンスステータスレポートには、次の列があります:

- **プロジェクト**: 不遵守のプロジェクト。
- **フレームワーク**: コントロールが属するコンプライアンスフレームワーク（GitLabやSOC 2など）。
- **制御**: プロジェクトが遵守していない特定のコントロール（「少なくとも2つの承認」など）。
- **Detected on**（検出日）: 不遵守が最初に記録された日付と時刻。
- **詳細情報**: プロジェクトの追加コンテキストまたは関連設定へのリンク。

## コンプライアンスステータスレポートをエクスポートします。 {#export-compliance-status-report}

グループ内のプロジェクトのステータスレポートの内容をエクスポートします。レポートは、大きなメール添付ファイルを回避するために15MBで切り詰められます。

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

グループ内のプロジェクトのコンプライアンスステータスレポートをエクスポートするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ** > **コンプライアンスセンター**を選択します。
1. 右上隅で、**エクスポート**を選択します。
1. **Export compliance status report**（コンプライアンスステータスレポートのエクスポート）を選択します。

レポートがコンパイルされ、添付ファイルとしてメールの受信箱に配信されます。
