/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContentImpl;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public ObjectStubTree<?> readOrBuild(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(1);
        }
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        return this.build(project, vFile, psiFile);
    }

    @Override
    @Nullable
    public ObjectStubTree<?> build(@Nullable Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(2);
        }
        try {
            FileContent fc = FileContentImpl.createByFile(vFile, project);
            Stub element = StubTreeBuilder.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return null;
    }

    @Override
    public ObjectStubTree<?> readFromVFile(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public boolean canHaveStub(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l2 = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l2);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/CoreStubTreeLoader";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readOrBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromVFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

