/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonIrAttributesKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0011\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0005*\u00020\u0019H\u0002\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u0019\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u001b\u0010\u001f\u001a\u00020\u0005*\u00020 8F\u00a2\u0006\f\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"isInlineParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "inlineScopeVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getInlineScopeVisibility", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "isInPublicInlineScope", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "original", "getOriginal", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "unwrapInlineLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "isInlineFunctionCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isInlineOnly", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isPrivateInlineSuspend", "getDeclarationBeforeInline", "Lorg/jetbrains/kotlin/ir/IrElement;", "getAttributeOwnerBeforeInline", "fileParentBeforeInline", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFileParentBeforeInline", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "inlineDeclaration", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "getInlineDeclaration$annotations", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)V", "getInlineDeclaration", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmIrInlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIrInlineUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmIrInlineUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n1761#3,3:112\n*S KotlinDebug\n*F\n+ 1 JvmIrInlineUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmIrInlineUtilsKt\n*L\n70#1:112,3\n*E\n"})
public final class JvmIrInlineUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineParameter(@NotNull IrValueParameter $this$isInlineParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineParameter, (String)"<this>");
        if ($this$isInlineParameter.getKind() != IrParameterKind.Regular) return false;
        if ($this$isInlineParameter.isNoinline()) return false;
        if (!IrTypeUtilsKt.isFunction((IrType)$this$isInlineParameter.getType())) {
            if (!IrTypeUtilsKt.isSuspendFunction((IrType)$this$isInlineParameter.getType())) return false;
        }
        if (!IrTypeUtilsKt.isNullable((IrType)$this$isInlineParameter.getType())) return true;
        IrExpressionBody irExpressionBody = $this$isInlineParameter.getDefaultValue();
        IrExpressionBody irExpressionBody2 = irExpressionBody;
        if (irExpressionBody == null) return false;
        IrExpression irExpression = irExpressionBody2.getExpression();
        irExpressionBody2 = irExpression;
        if (irExpression == null) return false;
        IrType irType = irExpressionBody2.getType();
        irExpressionBody2 = irType;
        if (irType == null) return false;
        if (IrTypeUtilsKt.isNullable((IrType)irExpressionBody2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final DescriptorVisibility getInlineScopeVisibility(@NotNull IrDeclaration $this$inlineScopeVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineScopeVisibility, (String)"<this>");
        IrDeclaration owner = JvmIrInlineUtilsKt.getOriginal($this$inlineScopeVisibility);
        DescriptorVisibility result = null;
        while (owner != null) {
            IrDeclarationParent irDeclarationParent;
            if (owner instanceof IrFunction && ((IrFunction)owner).isInline()) {
                DescriptorVisibility descriptorVisibility;
                if (!DescriptorVisibilities.isPrivate(((IrFunction)owner).getVisibility())) {
                    boolean bl;
                    Object object = IrUtilsKt.getParentClassOrNull((IrDeclaration)owner);
                    if (object != null && (object = object.getVisibility()) != null) {
                        Object object2 = object;
                        boolean bl2 = false;
                        bl = DescriptorVisibilities.isPrivate((DescriptorVisibility)object2);
                    } else {
                        bl = false;
                    }
                    if (!bl) return ((IrFunction)owner).getVisibility();
                    descriptorVisibility = DescriptorVisibilities.PRIVATE;
                } else {
                    descriptorVisibility = ((IrFunction)owner).getVisibility();
                }
                result = descriptorVisibility;
            }
            IrDeclaration irDeclaration = (irDeclarationParent = owner.getParent()) instanceof IrDeclaration ? (IrDeclaration)irDeclarationParent : null;
            owner = irDeclaration != null ? JvmIrInlineUtilsKt.getOriginal(irDeclaration) : null;
        }
        return result;
    }

    public static final boolean isInPublicInlineScope(@NotNull IrDeclaration $this$isInPublicInlineScope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInPublicInlineScope, (String)"<this>");
        DescriptorVisibility descriptorVisibility = JvmIrInlineUtilsKt.getInlineScopeVisibility($this$isInPublicInlineScope);
        if (descriptorVisibility != null) {
            DescriptorVisibility p0 = descriptorVisibility;
            boolean bl2 = false;
            bl = !DescriptorVisibilities.isPrivate(p0);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final IrDeclaration getOriginal(IrDeclaration $this$original) {
        IrElement irElement = $this$original.getAttributeOwnerId();
        IrDeclaration irDeclaration = irElement instanceof IrDeclaration ? (IrDeclaration)irElement : null;
        if (irDeclaration == null) {
            irDeclaration = $this$original;
        }
        return irDeclaration;
    }

    @Nullable
    public static final IrFunctionReference unwrapInlineLambda(@NotNull IrStatement $this$unwrapInlineLambda) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapInlineLambda, (String)"<this>");
        IrStatement irStatement = $this$unwrapInlineLambda;
        if (irStatement instanceof IrBlock) {
            IrStatement irStatement2 = (IrStatement)CollectionsKt.lastOrNull((List)((IrBlock)$this$unwrapInlineLambda).getStatements());
            object = irStatement2 != null ? JvmIrInlineUtilsKt.unwrapInlineLambda(irStatement2) : null;
        } else if (irStatement instanceof IrFunctionReference) {
            IrStatement irStatement3 = $this$unwrapInlineLambda;
            IrFunctionReference it = (IrFunctionReference)irStatement3;
            boolean bl = false;
            object = (IrFunctionReference)(Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrStatementOrigin.Companion.getINLINE_LAMBDA()) ? irStatement3 : null);
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineFunctionCall(@NotNull IrFunction $this$isInlineFunctionCall, @NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getConfig().isInlineDisabled()) {
            IrTypeParameter it;
            Iterable $this$any$iv = $this$isInlineFunctionCall.getTypeParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (IrTypeParameter)element$iv;
                boolean bl = false;
            } while (!it.isReified());
            boolean bl = true;
            if (!bl) return false;
        }
        if ($this$isInlineFunctionCall.isInline()) return true;
        if (!AdditionalIrUtilsKt.isInlineArrayConstructor((IrFunction)$this$isInlineFunctionCall)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnly(@NotNull IrDeclaration $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
        if (!($this$isInlineOnly instanceof IrFunction)) return false;
        if (((IrFunction)$this$isInlineOnly).isInline()) {
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$isInlineOnly), (FqName)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME())) return true;
        }
        if (!($this$isInlineOnly instanceof IrSimpleFunction)) return false;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$isInlineOnly).getCorrespondingPropertySymbol();
        IrPropertySymbol irPropertySymbol2 = irPropertySymbol;
        if (irPropertySymbol == null) return false;
        IrProperty irProperty = (IrProperty)irPropertySymbol2.getOwner();
        irPropertySymbol2 = irProperty;
        if (irProperty == null) return false;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irPropertySymbol2), (FqName)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME())) return false;
        return true;
    }

    public static final boolean isEffectivelyInlineOnly(@NotNull IrDeclarationWithVisibility $this$isEffectivelyInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyInlineOnly, (String)"<this>");
        return $this$isEffectivelyInlineOnly instanceof IrFunction && (IrInlineUtilsKt.isReifiable((IrFunction)((IrFunction)$this$isEffectivelyInlineOnly)) || JvmIrInlineUtilsKt.isInlineOnly((IrDeclaration)$this$isEffectivelyInlineOnly) || JvmIrInlineUtilsKt.isPrivateInlineSuspend((IrFunction)$this$isEffectivelyInlineOnly));
    }

    public static final boolean isPrivateInlineSuspend(@NotNull IrFunction $this$isPrivateInlineSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrivateInlineSuspend, (String)"<this>");
        return AdditionalIrUtilsKt.isSuspend((IrFunction)$this$isPrivateInlineSuspend) && $this$isPrivateInlineSuspend.isInline() && Intrinsics.areEqual((Object)$this$isPrivateInlineSuspend.getVisibility(), (Object)DescriptorVisibilities.PRIVATE);
    }

    private static final IrDeclaration getDeclarationBeforeInline(IrElement $this$getDeclarationBeforeInline) {
        IrElement irElement = CommonIrAttributesKt.getOriginalBeforeInline((IrElement)$this$getDeclarationBeforeInline);
        if (irElement == null) {
            return null;
        }
        IrElement original = irElement;
        return IrUtilsKt.extractRelatedDeclaration((IrElement)original);
    }

    @Nullable
    public static final IrElement getAttributeOwnerBeforeInline(@NotNull IrElement $this$getAttributeOwnerBeforeInline) {
        Intrinsics.checkNotNullParameter((Object)$this$getAttributeOwnerBeforeInline, (String)"<this>");
        if (CommonIrAttributesKt.getOriginalBeforeInline((IrElement)$this$getAttributeOwnerBeforeInline) == null) {
            return null;
        }
        return (IrElement)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$getAttributeOwnerBeforeInline, JvmIrInlineUtilsKt::getAttributeOwnerBeforeInline$lambda$3));
    }

    @NotNull
    public static final IrFile getFileParentBeforeInline(@NotNull IrDeclaration $this$fileParentBeforeInline) {
        Intrinsics.checkNotNullParameter((Object)$this$fileParentBeforeInline, (String)"<this>");
        Object object = JvmIrInlineUtilsKt.getDeclarationBeforeInline((IrElement)$this$fileParentBeforeInline);
        if (object == null) {
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)$this$fileParentBeforeInline);
            object = irClass != null ? JvmIrInlineUtilsKt.getDeclarationBeforeInline((IrElement)irClass) : null;
            if (object == null) {
                object = $this$fileParentBeforeInline;
            }
        }
        IrDeclaration original = object;
        return JvmIrUtilsKt.getFileParent(original);
    }

    @NotNull
    public static final IrDeclaration getInlineDeclaration(@NotNull IrInlinedFunctionBlock $this$inlineDeclaration) {
        IrDeclaration irDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$inlineDeclaration, (String)"<this>");
        IrElement element = org.jetbrains.kotlin.ir.util.IrInlineUtilsKt.getInlinedElement((IrInlinedFunctionBlock)$this$inlineDeclaration);
        if (element instanceof IrFunction) {
            irDeclaration = (IrDeclaration)element;
        } else if (element instanceof IrFunctionExpression) {
            irDeclaration = (IrDeclaration)((IrFunctionExpression)element).getFunction();
        } else if (element instanceof IrFunctionReference) {
            irDeclaration = (IrDeclaration)((IrFunctionSymbol)((IrFunctionReference)element).getSymbol()).getOwner();
        } else if (element instanceof IrPropertyReference) {
            irDeclaration = (IrDeclaration)((IrPropertySymbol)((IrPropertyReference)element).getSymbol()).getOwner();
        } else {
            IrElement irElement = element;
            throw new AssertionError((Object)("Not supported ir element for inlining " + (irElement != null ? DumpIrTreeKt.dump$default((IrElement)irElement, null, (int)1, null) : null)));
        }
        return irDeclaration;
    }

    public static /* synthetic */ void getInlineDeclaration$annotations(IrInlinedFunctionBlock irInlinedFunctionBlock) {
    }

    private static final IrElement getAttributeOwnerBeforeInline$lambda$3(IrElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonIrAttributesKt.getOriginalBeforeInline((IrElement)it);
    }
}

