/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/actions/ConfigureKotlinInProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nConfigureKotlinInProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/jvm/shared/actions/ConfigureKotlinInProjectAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1740#2,3:51\n1740#2,3:54\n774#2:57\n865#2,2:58\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/jvm/shared/actions/ConfigureKotlinInProjectAction\n*L\n31#1:51,3\n22#1:54,3\n25#1:57\n25#1:58,2\n*E\n"})
public final class ConfigureKotlinInProjectAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        List configurators;
        Project project;
        block9: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            project = project2;
            String progressTitle = KotlinJvmBundle.message("lookup.project.configurators.progress.text", new Object[0]);
            Pair pair = (Pair)ActionUtil.underModalProgress((Project)project, (String)progressTitle, () -> ConfigureKotlinInProjectAction.actionPerformed$lambda$0(project));
            List modules2 = (List)pair.component1();
            configurators = (List)pair.component2();
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            String string = KotlinJvmBundle.message("all.modules.with.kotlin.files.are.configured", new Object[0]);
            String string2 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string2);
            Messages.showInfoMessage((String)string, (String)string2);
            return;
        }
        if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((List)configurators)).configure(project, CollectionsKt.emptyList());
        } else if (configurators.isEmpty()) {
            String string = KotlinJvmBundle.message("there.aren.t.configurators.available", new Object[0]);
            String string3 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string3);
            Messages.showErrorDialog((String)string, (String)string3);
        } else {
            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup$default(KotlinSetupEnvironmentNotificationProvider.Companion, project, CollectionsKt.toList((Iterable)configurators), null, 4, null);
            configuratorsPopup.showInBestPositionFor(e.getDataContext());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair actionPerformed$lambda$0(Project $project) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List<ModuleSourceRootGroup> modules2;
        block5: {
            modules2 = ConfigureKotlinInProjectUtilsKt.getConfigurableModules($project);
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv2;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return TuplesKt.to(modules2, (Object)CollectionsKt.emptyList());
        }
        Iterable $this$filter$iv = ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators($project);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
            boolean bl3 = false;
            if (!JvmPlatformKt.isJvm((TargetPlatform)it.getTargetPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configurators = (List)destination$iv$iv;
        return TuplesKt.to(modules2, (Object)configurators);
    }
}

