/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractDomainType;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.sqm.tree.domain.SqmManagedDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.DynamicModelJavaType;

public abstract class AbstractManagedType<J>
extends AbstractDomainType<J>
implements SqmManagedDomainType<J>,
AttributeContainer<J>,
Serializable {
    private final String hibernateTypeName;
    private final SqmManagedDomainType<? super J> supertype;
    private final RepresentationMode representationMode;
    private final JpaMetamodelImplementor metamodel;
    private final Map<String, SqmSingularPersistentAttribute<J, ?>> declaredSingularAttributes = new LinkedHashMap();
    private volatile Map<String, SqmPluralPersistentAttribute<J, ?, ?>> declaredPluralAttributes;
    private volatile Map<String, SqmPersistentAttribute<J, ?>> declaredConcreteGenericAttributes;
    private final List<SqmManagedDomainType<? extends J>> subtypes = new ArrayList<SqmManagedDomainType<? extends J>>();
    private transient AttributeContainer.InFlightAccess<J> inFlightAccess;

    protected AbstractManagedType(String hibernateTypeName, JavaType<J> javaType, ManagedDomainType<? super J> supertype, JpaMetamodelImplementor metamodel) {
        super(javaType);
        this.hibernateTypeName = hibernateTypeName;
        this.supertype = (SqmManagedDomainType)supertype;
        this.metamodel = metamodel;
        if (supertype != null) {
            supertype.addSubType(this);
        }
        this.representationMode = AbstractManagedType.representationMode(javaType);
        this.inFlightAccess = this.createInFlightAccess();
    }

    private static <J> RepresentationMode representationMode(JavaType<J> javaType) {
        return javaType instanceof DynamicModelJavaType ? RepresentationMode.MAP : RepresentationMode.POJO;
    }

    protected AttributeContainer.InFlightAccess<J> createInFlightAccess() {
        return new InFlightAccessImpl();
    }

    @Override
    public JpaMetamodelImplementor getMetamodel() {
        return this.metamodel;
    }

    @Override
    public Class<J> getJavaType() {
        return super.getJavaType();
    }

    @Override
    public SqmManagedDomainType<? super J> getSuperType() {
        return this.supertype;
    }

    @Override
    public Collection<? extends SqmManagedDomainType<? extends J>> getSubTypes() {
        return this.subtypes;
    }

    @Override
    public void addSubType(ManagedDomainType<? extends J> subType) {
        this.subtypes.add((SqmManagedDomainType)subType);
    }

    @Override
    public RepresentationMode getRepresentationMode() {
        return this.representationMode;
    }

    @Override
    public void visitAttributes(Consumer<? super PersistentAttribute<? super J, ?>> action) {
        this.visitDeclaredAttributes(action);
        if (this.getSuperType() != null) {
            this.getSuperType().visitAttributes(action);
        }
    }

    @Override
    public void visitDeclaredAttributes(Consumer<? super PersistentAttribute<J, ?>> action) {
        this.declaredSingularAttributes.values().forEach(action);
        if (this.declaredPluralAttributes != null) {
            this.declaredPluralAttributes.values().forEach(action);
        }
    }

    public Set<Attribute<? super J, ?>> getAttributes() {
        LinkedHashSet attributes = new LinkedHashSet(this.getDeclaredAttributes());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getAttributes());
        }
        return attributes;
    }

    public Set<Attribute<J, ?>> getDeclaredAttributes() {
        boolean isDeclaredSingularAttributesEmpty = CollectionHelper.isEmpty(this.declaredSingularAttributes);
        boolean isDeclaredPluralAttributes = CollectionHelper.isEmpty(this.declaredPluralAttributes);
        if (isDeclaredSingularAttributesEmpty && isDeclaredPluralAttributes) {
            return Collections.emptySet();
        }
        if (!isDeclaredSingularAttributesEmpty) {
            LinkedHashSet attributes = new LinkedHashSet(this.declaredSingularAttributes.values());
            if (!isDeclaredPluralAttributes) {
                attributes.addAll(this.declaredPluralAttributes.values());
            }
            return attributes;
        }
        return new LinkedHashSet(this.declaredPluralAttributes.values());
    }

    @Override
    public SqmPersistentAttribute<? super J, ?> getAttribute(String name) {
        PersistentAttribute attribute = this.findAttribute(name);
        this.checkNotNull("Attribute", attribute, name);
        return attribute;
    }

    @Override
    public SqmPersistentAttribute<? super J, ?> findAttribute(String name) {
        PersistentAttribute attribute = this.findDeclaredAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        return this.supertype != null ? this.supertype.findAttribute(name) : null;
    }

    @Override
    public final SqmPersistentAttribute<? super J, ?> findAttributeInSuperTypes(String name) {
        PersistentAttribute attribute = this.findDeclaredAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        return this.supertype != null ? this.supertype.findAttributeInSuperTypes(name) : null;
    }

    @Override
    public SqmPersistentAttribute<?, ?> findSubTypesAttribute(String name) {
        PersistentAttribute attribute = this.findDeclaredAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        for (SqmManagedDomainType<J> subtype : this.subtypes) {
            PersistentAttribute subTypeAttribute = subtype.findSubTypesAttribute(name);
            if (subTypeAttribute == null) continue;
            return subTypeAttribute;
        }
        return null;
    }

    @Override
    public SqmPersistentAttribute<J, ?> findDeclaredAttribute(String name) {
        SqmSingularPersistentAttribute<J, ?> attribute = this.declaredSingularAttributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.declaredPluralAttributes != null) {
            return this.declaredPluralAttributes.get(name);
        }
        return null;
    }

    @Override
    public PersistentAttribute<J, ?> getDeclaredAttribute(String name) {
        PersistentAttribute attribute = this.findDeclaredAttribute(name);
        this.checkNotNull("Attribute", attribute, name);
        return attribute;
    }

    private void checkNotNull(String attributeType, Attribute<?, ?> attribute, String name) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Unable to locate %s with the given name [%s] on this ManagedType [%s]", attributeType, name, this.getTypeName()));
        }
    }

    @Override
    public String getTypeName() {
        return this.hibernateTypeName;
    }

    public Set<SingularAttribute<? super J, ?>> getSingularAttributes() {
        HashSet attributes = new HashSet(this.declaredSingularAttributes.values());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getSingularAttributes());
        }
        return attributes;
    }

    public Set<SingularAttribute<J, ?>> getDeclaredSingularAttributes() {
        return new HashSet(this.declaredSingularAttributes.values());
    }

    public SingularPersistentAttribute<? super J, ?> getSingularAttribute(String name) {
        SingularPersistentAttribute attribute = this.findSingularAttribute(name);
        this.checkNotNull("SingularAttribute", attribute, name);
        return attribute;
    }

    @Override
    public SqmSingularPersistentAttribute<? super J, ?> findSingularAttribute(String name) {
        SingularPersistentAttribute attribute = this.findDeclaredSingularAttribute(name);
        return attribute == null && this.getSuperType() != null ? this.getSuperType().findSingularAttribute(name) : attribute;
    }

    public <Y> SqmSingularPersistentAttribute<? super J, Y> getSingularAttribute(String name, Class<Y> type) {
        return this.checkTypeForSingleAttribute((SqmSingularPersistentAttribute)this.findSingularAttribute(name), name, type);
    }

    public SingularAttribute<J, ?> getDeclaredSingularAttribute(String name) {
        SingularPersistentAttribute attribute = this.findDeclaredSingularAttribute(name);
        this.checkNotNull("SingularAttribute", attribute, name);
        return attribute;
    }

    @Override
    public SqmSingularPersistentAttribute<J, ?> findDeclaredSingularAttribute(String name) {
        return this.declaredSingularAttributes.get(name);
    }

    public <Y> SingularPersistentAttribute<J, Y> getDeclaredSingularAttribute(String name, Class<Y> javaType) {
        return this.checkTypeForSingleAttribute((SqmSingularPersistentAttribute)this.findDeclaredSingularAttribute(name), name, javaType);
    }

    private <K, Y> SqmSingularPersistentAttribute<K, Y> checkTypeForSingleAttribute(SqmSingularPersistentAttribute<K, ?> attribute, String name, Class<Y> javaType) {
        if (attribute == null || !this.hasMatchingReturnType(attribute, javaType)) {
            throw new IllegalArgumentException("SingularAttribute named " + name + (String)(javaType != null ? " and of type " + javaType.getName() : "") + " is not present");
        }
        SqmSingularPersistentAttribute<K, ?> narrowed = attribute;
        return narrowed;
    }

    private <T, Y> boolean hasMatchingReturnType(SingularAttribute<T, ?> attribute, Class<Y> javaType) {
        return javaType == null || attribute.getJavaType().equals(javaType) || this.isPrimitiveVariant(attribute, javaType);
    }

    protected <Y> boolean isPrimitiveVariant(SingularAttribute<?, ?> attribute, Class<Y> javaType) {
        if (attribute != null) {
            Class declaredType = attribute.getJavaType();
            if (declaredType.isPrimitive()) {
                return Boolean.class.equals(javaType) && Boolean.TYPE.equals(declaredType) || Character.class.equals(javaType) && Character.TYPE.equals(declaredType) || Byte.class.equals(javaType) && Byte.TYPE.equals(declaredType) || Short.class.equals(javaType) && Short.TYPE.equals(declaredType) || Integer.class.equals(javaType) && Integer.TYPE.equals(declaredType) || Long.class.equals(javaType) && Long.TYPE.equals(declaredType) || Float.class.equals(javaType) && Float.TYPE.equals(declaredType) || Double.class.equals(javaType) && Double.TYPE.equals(declaredType);
            }
            if (javaType.isPrimitive()) {
                return Boolean.class.equals((Object)declaredType) && Boolean.TYPE.equals(javaType) || Character.class.equals((Object)declaredType) && Character.TYPE.equals(javaType) || Byte.class.equals((Object)declaredType) && Byte.TYPE.equals(javaType) || Short.class.equals((Object)declaredType) && Short.TYPE.equals(javaType) || Integer.class.equals((Object)declaredType) && Integer.TYPE.equals(javaType) || Long.class.equals((Object)declaredType) && Long.TYPE.equals(javaType) || Float.class.equals((Object)declaredType) && Float.TYPE.equals(javaType) || Double.class.equals((Object)declaredType) && Double.TYPE.equals(javaType);
            }
        }
        return false;
    }

    public Set<PluralAttribute<? super J, ?, ?>> getPluralAttributes() {
        HashSet attributes;
        HashSet<Object> hashSet = attributes = this.declaredPluralAttributes == null ? new HashSet() : new HashSet(this.declaredPluralAttributes.values());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getPluralAttributes());
        }
        return attributes;
    }

    public Set<PluralAttribute<J, ?, ?>> getDeclaredPluralAttributes() {
        return this.declaredPluralAttributes == null ? Collections.emptySet() : new HashSet(this.declaredPluralAttributes.values());
    }

    @Override
    public SqmPluralPersistentAttribute<? super J, ?, ?> findPluralAttribute(String name) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.getSuperType() != null) {
            return this.getSuperType().findPluralAttribute(name);
        }
        return null;
    }

    @Override
    public SqmPluralPersistentAttribute<J, ?, ?> findDeclaredPluralAttribute(String name) {
        return this.declaredPluralAttributes == null ? null : this.declaredPluralAttributes.get(name);
    }

    private <E> void checkTypeForPluralAttributes(String attributeType, PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType, PluralAttribute.CollectionType collectionType) {
        if (attribute == null || elementType != null && !attribute.getBindableJavaType().equals(elementType) || attribute.getCollectionType() != collectionType) {
            throw new IllegalArgumentException(attributeType + " named " + name + (String)(elementType != null ? " and of element type " + String.valueOf(elementType) : "") + " is not present");
        }
    }

    @Override
    public SqmPersistentAttribute<? super J, ?> findConcreteGenericAttribute(String name) {
        PersistentAttribute attribute = this.findDeclaredConcreteGenericAttribute(name);
        return attribute == null && this.getSuperType() != null ? this.getSuperType().findDeclaredConcreteGenericAttribute(name) : attribute;
    }

    @Override
    public SqmPersistentAttribute<J, ?> findDeclaredConcreteGenericAttribute(String name) {
        return this.declaredConcreteGenericAttributes == null ? null : this.declaredConcreteGenericAttributes.get(name);
    }

    public BagPersistentAttribute<? super J, ?> getCollection(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        if (attribute == null && this.getSuperType() != null) {
            attribute = this.getSuperType().findPluralAttribute(name);
        }
        this.basicCollectionCheck(attribute, name);
        return (BagPersistentAttribute)attribute;
    }

    private void basicCollectionCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("CollectionAttribute", (Attribute<?, ?>)attribute, name);
        if (!BagPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a CollectionAttribute: " + String.valueOf(attribute.getClass()));
        }
    }

    public CollectionAttribute<J, ?> getDeclaredCollection(String name) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.basicCollectionCheck(attribute, name);
        return (CollectionAttribute)attribute;
    }

    public <E> BagPersistentAttribute<? super J, E> getCollection(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkCollectionElementType(attribute, name, elementType);
        return (BagPersistentAttribute)attribute;
    }

    private <E> void checkCollectionElementType(PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("CollectionAttribute", attribute, name, elementType, PluralAttribute.CollectionType.COLLECTION);
    }

    public <E> CollectionAttribute<J, E> getDeclaredCollection(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.checkCollectionElementType(attribute, name, elementType);
        return (CollectionAttribute)attribute;
    }

    public SetPersistentAttribute<? super J, ?> getSet(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicSetCheck(attribute, name);
        return (SetPersistentAttribute)attribute;
    }

    private void basicSetCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("SetAttribute", (Attribute<?, ?>)attribute, name);
        if (!SetPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a SetAttribute: " + String.valueOf(attribute.getClass()));
        }
    }

    public SetPersistentAttribute<J, ?> getDeclaredSet(String name) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.basicSetCheck(attribute, name);
        return (SetPersistentAttribute)attribute;
    }

    public <E> SetAttribute<? super J, E> getSet(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)attribute;
    }

    private <E> void checkSetElementType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("SetAttribute", attribute, name, elementType, PluralAttribute.CollectionType.SET);
    }

    public <E> SetAttribute<J, E> getDeclaredSet(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)attribute;
    }

    public ListPersistentAttribute<? super J, ?> getList(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicListCheck(attribute, name);
        return (ListPersistentAttribute)attribute;
    }

    private void basicListCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("ListAttribute", (Attribute<?, ?>)attribute, name);
        if (!ListPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a ListAttribute: " + String.valueOf(attribute.getClass()));
        }
    }

    public ListPersistentAttribute<J, ?> getDeclaredList(String name) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.basicListCheck(attribute, name);
        return (ListPersistentAttribute)attribute;
    }

    public <E> ListAttribute<? super J, E> getList(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)attribute;
    }

    private <E> void checkListElementType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("ListAttribute", attribute, name, elementType, PluralAttribute.CollectionType.LIST);
    }

    public <E> ListAttribute<J, E> getDeclaredList(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)attribute;
    }

    public MapPersistentAttribute<? super J, ?, ?> getMap(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicMapCheck(attribute, name);
        return (MapPersistentAttribute)attribute;
    }

    private void basicMapCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("MapAttribute", (Attribute<?, ?>)attribute, name);
        if (!MapAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a MapAttribute: " + String.valueOf(attribute.getClass()));
        }
    }

    public MapPersistentAttribute<J, ?, ?> getDeclaredMap(String name) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.basicMapCheck(attribute, name);
        return (MapPersistentAttribute)attribute;
    }

    public <K, V> MapAttribute<? super J, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)attribute;
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    private <V> void checkMapValueType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<V> valueType) {
        this.checkTypeForPluralAttributes("MapAttribute", attribute, name, valueType, PluralAttribute.CollectionType.MAP);
    }

    private <K, V> void checkMapKeyType(MapAttribute<? super J, K, V> mapAttribute, String name, Class<K> keyType) {
        if (mapAttribute.getKeyJavaType() != keyType) {
            throw new IllegalArgumentException("MapAttribute named " + name + " does not support a key of type " + String.valueOf(keyType));
        }
    }

    public <K, V> MapAttribute<J, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralPersistentAttribute attribute = this.findDeclaredPluralAttribute(name);
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)attribute;
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.metamodel, this.getJavaType());
    }

    @Override
    public AttributeContainer.InFlightAccess<J> getInFlightAccess() {
        if (this.inFlightAccess == null) {
            throw new IllegalStateException("Type has been locked");
        }
        return this.inFlightAccess;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hibernateTypeName + "]";
    }

    protected class InFlightAccessImpl
    implements AttributeContainer.InFlightAccess<J> {
        protected InFlightAccessImpl() {
        }

        @Override
        public void addAttribute(PersistentAttribute<J, ?> attribute) {
            if (attribute instanceof SqmSingularPersistentAttribute) {
                SqmSingularPersistentAttribute singularAttribute = (SqmSingularPersistentAttribute)attribute;
                AbstractManagedType.this.declaredSingularAttributes.put(attribute.getName(), singularAttribute);
            } else if (attribute instanceof SqmPluralPersistentAttribute) {
                SqmPluralPersistentAttribute pluralAttribute = (SqmPluralPersistentAttribute)attribute;
                if (AbstractManagedType.this.declaredPluralAttributes == null) {
                    AbstractManagedType.this.declaredPluralAttributes = new HashMap();
                }
                AbstractManagedType.this.declaredPluralAttributes.put(attribute.getName(), pluralAttribute);
            } else {
                throw new IllegalArgumentException("Unable to classify attribute as singular or plural [" + String.valueOf(attribute) + "] for `" + String.valueOf(this) + "`");
            }
        }

        @Override
        public void addConcreteGenericAttribute(PersistentAttribute<J, ?> attribute) {
            if (AbstractManagedType.this.declaredConcreteGenericAttributes == null) {
                AbstractManagedType.this.declaredConcreteGenericAttributes = new HashMap();
            }
            AbstractManagedType.this.declaredConcreteGenericAttributes.put(attribute.getName(), (SqmPersistentAttribute)attribute);
        }

        @Override
        public void finishUp() {
            AbstractManagedType.this.inFlightAccess = null;
        }
    }

    private static class SerialForm
    implements Serializable {
        private final JpaMetamodel jpaMetamodel;
        private final Class<?> typeClass;

        public SerialForm(JpaMetamodel jpaMetamodel, Class<?> typeClass) {
            this.jpaMetamodel = jpaMetamodel;
            this.typeClass = typeClass;
        }

        private Object readResolve() {
            return this.jpaMetamodel.managedType(this.typeClass);
        }
    }
}

