/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

public class SortedSetSubsetArgs<T> {
    private final boolean isRev;
    private final T start;
    private final T stop;
    private final boolean includeStart;
    private final boolean includeStop;
    private final Long offset;
    private final Long count;

    private SortedSetSubsetArgs(Builder<T> builder) {
        this.isRev = builder.isRev;
        this.start = builder.min;
        this.stop = builder.max;
        this.includeStart = builder.includeMin;
        this.includeStop = builder.includeMax;
        this.offset = builder.offset;
        this.count = builder.count;
    }

    public static Builder create() {
        return new Builder();
    }

    public boolean isRev() {
        return this.isRev;
    }

    public T getStart() {
        return this.start;
    }

    public T getStop() {
        return this.stop;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public boolean isIncludeStop() {
        return this.includeStop;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "SortedSetSubsetArgs{isRev=" + this.isRev + ", start=" + String.valueOf(this.start) + ", stop=" + String.valueOf(this.stop) + ", includeStart=" + this.includeStart + ", includeStop=" + this.includeStop + ", offset=" + this.offset + ", count=" + this.count + "}";
    }

    public static class Builder<T> {
        private boolean isRev;
        private T min;
        private T max;
        private boolean includeMin;
        private boolean includeMax;
        private Long offset;
        private Long count;

        private Builder() {
        }

        public Builder<T> start(T start) {
            this.min = start;
            return this;
        }

        public Builder<T> stop(T stop) {
            this.max = stop;
            return this;
        }

        public Builder<T> includeStart(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder<T> includeStop(boolean include) {
            this.includeMax = include;
            return this;
        }

        public Builder<T> isRev(boolean isRev) {
            this.isRev = isRev;
            return this;
        }

        public Builder<T> offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder<T> count(Long count) {
            this.count = count;
            return this;
        }

        public SortedSetSubsetArgs<T> build() {
            return new SortedSetSubsetArgs(this);
        }
    }
}

