/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.tls.runtime.KeyStoreProvider;
import io.quarkus.tls.runtime.config.JKSKeyStoreConfig;
import io.quarkus.tls.runtime.config.KeyStoreCredentialProviderConfig;
import io.quarkus.tls.runtime.config.P12KeyStoreConfig;
import io.quarkus.tls.runtime.config.PemKeyCertConfig;
import io.smallrye.config.WithDefault;
import java.util.Optional;

@ConfigGroup
public interface KeyStoreConfig {
    public Optional<PemKeyCertConfig> pem();

    public Optional<P12KeyStoreConfig> p12();

    public Optional<JKSKeyStoreConfig> jks();

    @WithDefault(value="false")
    public boolean sni();

    public KeyStoreCredentialProviderConfig credentialsProvider();

    default public void validate(InstanceHandle<KeyStoreProvider> provider, String name) {
        if (provider.isAvailable() && (this.pem().isPresent() || this.p12().isPresent() || this.jks().isPresent())) {
            throw new IllegalStateException("Invalid truststore '" + name + "' - The keystore cannot be configured with a provider and PEM or PKCS12 or JKS at the same time");
        }
        if (this.pem().isPresent() && (this.p12().isPresent() || this.jks().isPresent())) {
            throw new IllegalStateException("Invalid keystore '" + name + "' - The keystore cannot be configured with PEM and PKCS12 or JKS at the same time");
        }
        if (this.p12().isPresent() && this.jks().isPresent()) {
            throw new IllegalStateException("Invalid keystore '" + name + "' - The keystore cannot be configured with PKCS12 and JKS at the same time");
        }
    }
}

