/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import mediathek.config.Konstanten;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;

public class AboutDialog
extends JDialog {
    private JLabel lblVersion;
    private JScrollPane scrollPane1;
    private JXHyperlink hyperlinkHomepage;
    private JXHyperlink hyperlinkGuiDonation;
    private JXHyperlink hyperlinkServerDonation;
    private JXHyperlink hyperlinkForum;
    private JXHyperlink hyperlinkOnlineHelp;
    private JXHyperlink hyperlinkJetBrains;
    private JXHyperlink hyperlinkEjTechnologies;

    public AboutDialog(Window owner) {
        super(owner);
        this.initComponents();
        this.lblVersion.setText(String.format("Version %s (%s)", Konstanten.MVVERSION, SystemUtils.OS_ARCH));
        this.hyperlinkHomepage.addActionListener(l -> this.browseToUrl("https://mediathekview.de/"));
        this.hyperlinkGuiDonation.addActionListener(l -> this.browseToUrl("https://paypal.me/ChristianFranzke"));
        this.hyperlinkServerDonation.addActionListener(l -> this.browseToUrl("https://mediathekview.de/spenden/"));
        this.hyperlinkForum.addActionListener(l -> this.browseToUrl("https://forum.mediathekview.de/"));
        this.hyperlinkOnlineHelp.addActionListener(l -> this.browseToUrl("https://mediathekview.de/anleitung/"));
        this.hyperlinkJetBrains.addActionListener(l -> this.browseToUrl("https://www.jetbrains.com"));
        this.hyperlinkEjTechnologies.addActionListener(l -> this.browseToUrl("https://www.ej-technologies.com"));
        SwingUtilities.invokeLater(() -> this.scrollPane1.getVerticalScrollBar().setValue(0));
    }

    private void showError() {
        JOptionPane.showMessageDialog(this, "Es konnte kein Browser ge\u00f6ffnet werden.", "MediathekView", 0);
    }

    private void browseToUrl(@NotNull String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.showError();
            }
        } else {
            this.showError();
        }
    }

    private void initComponents() {
        JLabel label1 = new JLabel();
        JPanel panel1 = new JPanel();
        JLabel label2 = new JLabel();
        this.lblVersion = new JLabel();
        JTabbedPane tabbedPane1 = new JTabbedPane();
        JPanel panel2 = new JPanel();
        JScrollPane scrollPane3 = new JScrollPane();
        JTextPane textPane1 = new JTextPane();
        JPanel panel3 = new JPanel();
        this.scrollPane1 = new JScrollPane();
        JTextPane textPane2 = new JTextPane();
        JPanel panel5 = new JPanel();
        this.hyperlinkHomepage = new JXHyperlink();
        this.hyperlinkGuiDonation = new JXHyperlink();
        this.hyperlinkServerDonation = new JXHyperlink();
        this.hyperlinkForum = new JXHyperlink();
        this.hyperlinkOnlineHelp = new JXHyperlink();
        JLabel label4 = new JLabel();
        JPanel panel4 = new JPanel();
        this.hyperlinkJetBrains = new JXHyperlink();
        this.hyperlinkEjTechnologies = new JXHyperlink();
        this.setTitle("\u00dcber dieses Programm");
        this.setModal(true);
        this.setMinimumSize(new Dimension(725, 470));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new MigLayout(new LC().fill().insets("5").hideMode(3).gridGap("5", "5"), new AC().size("316").fill().gap().fill(), new AC().fill().gap().fill().gap().fill()));
        label1.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/MediathekView.png")));
        contentPane.add((Component)label1, new CC().cell(0, 0));
        panel1.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("0", "0"), new AC().grow().align("left"), new AC().fill().gap().fill().gap("rel").grow().fill()));
        label2.setText("MediathekView");
        label2.setFont(label2.getFont().deriveFont(label2.getFont().getStyle() | 1, (float)label2.getFont().getSize() + 35.0f));
        panel1.add((Component)label2, new CC().cell(0, 0));
        this.lblVersion.setText("Version");
        panel1.add((Component)this.lblVersion, new CC().cell(0, 1));
        tabbedPane1.setTabLayoutPolicy(1);
        panel2.setPreferredSize(new Dimension(196, 220));
        panel2.setLayout(new BorderLayout());
        scrollPane3.setOpaque(false);
        scrollPane3.setMinimumSize(new Dimension(196, 162));
        textPane1.setText("MediathekView-Client:\nChristian Franzke (derreisende77)\n\nMediathekView-Server:\nNicklas Wiegandt (nicklas2751)\nPeter W. (pidoubleyou)\nSascha Wiegandt (thesasch)\n\nServer-Administration:\nAlexander Finkh\u00e4user (alex1702)");
        scrollPane3.setViewportView(textPane1);
        panel2.add((Component)scrollPane3, "Center");
        tabbedPane1.addTab("aktive Entwickler", panel2);
        panel3.setLayout(new BorderLayout());
        textPane2.setText("Gr\u00fcnder des Programms:\nXaver W. (xaverW)\n\nWeitere Beteiligte:\nsiedlerchr\nstyrol\nzxsd\napoleon\nhostis\npmshell\nclel\nthausherr\nklauswich");
        this.scrollPane1.setViewportView(textPane2);
        panel3.add((Component)this.scrollPane1, "Center");
        tabbedPane1.addTab("ehemalige Mitwirkende", panel3);
        panel1.add((Component)tabbedPane1, new CC().cell(0, 2).grow());
        contentPane.add((Component)panel1, new CC().cell(1, 0, 1, 2).grow());
        panel5.setLayout(new MigLayout(new LC().fillX().insets("5").hideMode(3).gridGap("5", "5"), new AC().size("316").fill(), new AC().fill().gap().fill().gap().fill().gap().fill().gap().fill()));
        this.hyperlinkHomepage.setText("Homepage");
        panel5.add((Component)this.hyperlinkHomepage, new CC().cell(0, 0));
        this.hyperlinkGuiDonation.setText("Spende an den Entwickler des Programms");
        panel5.add((Component)this.hyperlinkGuiDonation, new CC().cell(0, 1));
        this.hyperlinkServerDonation.setText("Spende f\u00fcr den Server-Betrieb");
        panel5.add((Component)this.hyperlinkServerDonation, new CC().cell(0, 2));
        this.hyperlinkForum.setText("Hilfe-Forum");
        panel5.add((Component)this.hyperlinkForum, new CC().cell(0, 3));
        this.hyperlinkOnlineHelp.setText("Online-Anleitung");
        panel5.add((Component)this.hyperlinkOnlineHelp, new CC().cell(0, 4));
        contentPane.add((Component)panel5, new CC().cell(0, 1).growX());
        label4.setText("Die Entwicklung wird unterst\u00fctzt von:");
        label4.setVerticalAlignment(1);
        contentPane.add((Component)label4, new CC().cell(0, 2));
        panel4.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("0", "0"), new AC().grow().align("left"), new AC().fill().gap().fill()));
        this.hyperlinkJetBrains.setText("JetBrains IntelliJ");
        this.hyperlinkJetBrains.setVerticalAlignment(1);
        panel4.add((Component)this.hyperlinkJetBrains, new CC().cell(0, 0).growX());
        this.hyperlinkEjTechnologies.setText("ej-technologies install4j & JProfiler");
        panel4.add((Component)this.hyperlinkEjTechnologies, new CC().cell(0, 1).growX());
        contentPane.add((Component)panel4, new CC().cell(1, 2));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

