/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;

public final class RecoveryResponse
extends TransportResponse {
    final List<String> phase1FileNames;
    final List<Long> phase1FileSizes;
    final List<String> phase1ExistingFileNames;
    final List<Long> phase1ExistingFileSizes;
    final long phase1TotalSize;
    final long phase1ExistingTotalSize;
    final long phase1Time;
    final long phase1ThrottlingWaitTime;
    final long startTime;
    final int phase2Operations;
    final long phase2Time;

    RecoveryResponse(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long phase1TotalSize, long phase1ExistingTotalSize, long phase1Time, long phase1ThrottlingWaitTime, long startTime, int phase2Operations, long phase2Time) {
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.phase1TotalSize = phase1TotalSize;
        this.phase1ExistingTotalSize = phase1ExistingTotalSize;
        this.phase1Time = phase1Time;
        this.phase1ThrottlingWaitTime = phase1ThrottlingWaitTime;
        this.startTime = startTime;
        this.phase2Operations = phase2Operations;
        this.phase2Time = phase2Time;
    }

    RecoveryResponse(StreamInput in) throws IOException {
        super(in);
        this.phase1FileNames = in.readStringList();
        this.phase1FileSizes = in.readList(StreamInput::readVLong);
        this.phase1ExistingFileNames = in.readStringList();
        this.phase1ExistingFileSizes = in.readList(StreamInput::readVLong);
        this.phase1TotalSize = in.readVLong();
        this.phase1ExistingTotalSize = in.readVLong();
        this.phase1Time = in.readVLong();
        this.phase1ThrottlingWaitTime = in.readVLong();
        this.startTime = in.readVLong();
        this.phase2Operations = in.readVInt();
        this.phase2Time = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.phase1FileNames);
        out.writeCollection(this.phase1FileSizes, StreamOutput::writeVLong);
        out.writeStringCollection(this.phase1ExistingFileNames);
        out.writeCollection(this.phase1ExistingFileSizes, StreamOutput::writeVLong);
        out.writeVLong(this.phase1TotalSize);
        out.writeVLong(this.phase1ExistingTotalSize);
        out.writeVLong(this.phase1Time);
        out.writeVLong(this.phase1ThrottlingWaitTime);
        out.writeVLong(this.startTime);
        out.writeVInt(this.phase2Operations);
        out.writeVLong(this.phase2Time);
    }
}

