/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.AlertingV2Utils;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.action.ExecuteWorkflowRequest;
import org.opensearch.alerting.action.ExecuteWorkflowResponse;
import org.opensearch.alerting.transport.TransportExecuteWorkflowActionKt;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.WorkflowRunResult;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/alerting/transport/TransportExecuteWorkflowAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/ExecuteWorkflowRequest;", "Lorg/opensearch/alerting/action/ExecuteWorkflowResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/alerting/MonitorRunnerService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "execWorkflowRequest", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportExecuteWorkflowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportExecuteWorkflowAction.kt\norg/opensearch/alerting/transport/TransportExecuteWorkflowAction\n+ 2 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n1#1,151:1\n173#2,8:152\n*S KotlinDebug\n*F\n+ 1 TransportExecuteWorkflowAction.kt\norg/opensearch/alerting/transport/TransportExecuteWorkflowAction\n*L\n60#1:152,8\n*E\n"})
public final class TransportExecuteWorkflowAction
extends HandledTransportAction<ExecuteWorkflowRequest, ExecuteWorkflowResponse> {
    @NotNull
    private final TransportService transportService;
    @NotNull
    private final Client client;
    @NotNull
    private final MonitorRunnerService runner;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportExecuteWorkflowAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull MonitorRunnerService runner, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opensearch/alerting/workflow/execute", transportService, actionFilters, ExecuteWorkflowRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.runner = runner;
        this.xContentRegistry = xContentRegistry;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull ExecuteWorkflowRequest execWorkflowRequest, @NotNull ActionListener<ExecuteWorkflowResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)execWorkflowRequest), (String)"execWorkflowRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        TransportExecuteWorkflowActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        ThreadContext.StoredContext $this$use$iv = this.client.threadPool().getThreadContext().stashContext();
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            ThreadContext.StoredContext it = $this$use$iv;
            boolean bl = false;
            Function1 executeWorkflow2 = arg_0 -> TransportExecuteWorkflowAction.doExecute$lambda$1$lambda$0(this, execWorkflowRequest, actionListener, arg_0);
            if (execWorkflowRequest.getWorkflowId() != null) {
                GetRequest getRequest = new GetRequest(".opendistro-alerting-config").id(execWorkflowRequest.getWorkflowId());
                this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, (Function1<? super Workflow, Unit>)executeWorkflow2, execWorkflowRequest){
                    final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                    final /* synthetic */ TransportExecuteWorkflowAction this$0;
                    final /* synthetic */ Function1<Workflow, Unit> $executeWorkflow;
                    final /* synthetic */ ExecuteWorkflowRequest $execWorkflowRequest;
                    {
                        this.$actionListener = $actionListener;
                        this.this$0 = $receiver;
                        this.$executeWorkflow = $executeWorkflow;
                        this.$execWorkflowRequest = $execWorkflowRequest;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(GetResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        if (!response2.isExists()) {
                            TransportExecuteWorkflowActionKt.access$getLog$p().error("Can't find workflow with id: " + response2.getId());
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Can't find workflow with id: " + response2.getId(), RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        if (!response2.isSourceEmpty()) {
                            Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                            Function1<Workflow, Unit> function1 = this.$executeWorkflow;
                            ActionListener<ExecuteWorkflowResponse> actionListener = this.$actionListener;
                            Throwable throwable = null;
                            try {
                                XContentParser xcp = (XContentParser)closeable;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)xcp);
                                String string = response2.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                                ScheduledJob scheduledJob2 = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                                Exception exception = AlertingV2Utils.INSTANCE.validateMonitorV1(scheduledJob2);
                                if (exception != null) {
                                    Exception it = exception;
                                    boolean bl2 = false;
                                    actionListener.onFailure((Exception)AlertingException.Companion.wrap(it));
                                    return;
                                }
                                Intrinsics.checkNotNull((Object)scheduledJob2, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                                Workflow workflow = (Workflow)scheduledJob2;
                                function1.invoke((Object)workflow);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        TransportExecuteWorkflowActionKt.access$getLog$p().error("Error getting workflow " + this.$execWorkflowRequest.getWorkflowId(), (Throwable)t);
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            } else {
                Workflow workflow;
                boolean bl2;
                User user2 = user;
                CharSequence charSequence = user2 != null ? user2.getName() : null;
                boolean bl3 = bl2 = charSequence == null || charSequence.length() == 0;
                if (bl2) {
                    Workflow workflow2 = execWorkflowRequest.getWorkflow();
                    workflow = workflow2;
                    Intrinsics.checkNotNull((Object)workflow2, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                } else if (!bl2) {
                    Workflow workflow3 = execWorkflowRequest.getWorkflow();
                    Intrinsics.checkNotNull((Object)workflow3, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                    workflow = Workflow.copy$default((Workflow)workflow3, null, (long)0L, null, (boolean)false, null, null, null, null, (User)user, (int)0, null, null, null, null, (int)16127, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Workflow workflow4 = workflow;
                executeWorkflow2.invoke((Object)workflow4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            exception$iv = e$iv;
            throw e$iv;
        }
        finally {
            AlertingUtilsKt.closeFinally($this$use$iv, exception$iv);
        }
    }

    private static final Unit doExecute$lambda$1$lambda$0(TransportExecuteWorkflowAction this$0, ExecuteWorkflowRequest $execWorkflowRequest, ActionListener<ExecuteWorkflowResponse> $actionListener, Workflow workflow) {
        BuildersKt.launch$default((CoroutineScope)this$0.runner, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($execWorkflowRequest, workflow, this$0, $actionListener, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ ExecuteWorkflowRequest $execWorkflowRequest;
            final /* synthetic */ Workflow $workflow;
            final /* synthetic */ TransportExecuteWorkflowAction this$0;
            final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
            {
                this.$execWorkflowRequest = $execWorkflowRequest;
                this.$workflow = $workflow;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$execWorkflowRequest.getRequestStart() != null ? new Pair((Object)Instant.ofEpochMilli(this.$execWorkflowRequest.getRequestStart().getMillis()), (Object)Instant.ofEpochMilli(this.$execWorkflowRequest.getRequestEnd().getMillis())) : this.$workflow.getSchedule().getPeriodEndingAt(Instant.ofEpochMilli(this.$execWorkflowRequest.getRequestEnd().getMillis()));
                        periodStart = (Instant)var2_3.component1();
                        periodEnd = (Instant)var2_3.component2();
                        TransportExecuteWorkflowActionKt.access$getLog$p().info("Executing workflow from API - id: " + this.$workflow.getId() + ", periodStart: " + periodStart + ", periodEnd: " + periodEnd + ", dryrun: " + this.$execWorkflowRequest.getDryrun());
                        Intrinsics.checkNotNull((Object)periodStart);
                        Intrinsics.checkNotNull((Object)periodEnd);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodStart);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                        this.label = 1;
                        v0 = MonitorRunnerService.INSTANCE.runJob(this.$workflow, periodStart, periodEnd, this.$execWorkflowRequest.getDryrun(), TransportExecuteWorkflowAction.access$getTransportService$p(this.this$0), (Continuation<? super WorkflowRunResult>)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl19
lbl18:
                        // 1 sources

                        return var6_2;
lbl19:
                        // 1 sources

                        ** GOTO lbl27
                    }
                    case 1: {
                        periodEnd = (Instant)this.L$1;
                        periodStart = (Instant)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        workflowRunResult = (WorkflowRunResult)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodStart);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)workflowRunResult);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, workflowRunResult, null){
                            int label;
                            final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                            final /* synthetic */ WorkflowRunResult $workflowRunResult;
                            {
                                this.$actionListener = $actionListener;
                                this.$workflowRunResult = $workflowRunResult;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$actionListener.onResponse((Object)((Object)new ExecuteWorkflowResponse(this.$workflowRunResult)));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var6_2) goto lbl35
lbl34:
                        // 1 sources

                        return var6_2;
lbl35:
                        // 1 sources

                        ** GOTO lbl61
                    }
                    case 2: {
                        workflowRunResult = (WorkflowRunResult)this.L$2;
                        periodEnd = (Instant)this.L$1;
                        periodStart = (Instant)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl61
                        }
                        catch (Exception e) {
                            TransportExecuteWorkflowActionKt.access$getLog$p().error("Unexpected error running workflow", (Throwable)e);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodStart);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.label = 3;
                            v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, e, null){
                                int label;
                                final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                                final /* synthetic */ Exception $e;
                                {
                                    this.$actionListener = $actionListener;
                                    this.$e = $e;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(this.$e));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl61
                        }
                    }
                    case 3: {
                        e = (Exception)this.L$2;
                        periodEnd = (Instant)this.L$1;
                        periodStart = (Instant)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl61:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TransportService access$getTransportService$p(TransportExecuteWorkflowAction $this) {
        return $this.transportService;
    }
}

