/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.aggregations.CompositeDateHistogramAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeGeoTileGridAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeHistogramAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeTermsAggregationSource;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CompositeAggregationSource
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CompositeAggregationSource> {
    @Nullable
    private final CompositeDateHistogramAggregationSource dateHistogram;
    @Nullable
    private final CompositeGeoTileGridAggregationSource geotileGrid;
    @Nullable
    private final CompositeHistogramAggregationSource histogram;
    @Nullable
    private final CompositeTermsAggregationSource terms;
    public static final JsonpDeserializer<CompositeAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregationSource::setupCompositeAggregationSourceDeserializer);

    private CompositeAggregationSource(Builder builder) {
        this.dateHistogram = builder.dateHistogram;
        this.geotileGrid = builder.geotileGrid;
        this.histogram = builder.histogram;
        this.terms = builder.terms;
    }

    public static CompositeAggregationSource of(Function<Builder, ObjectBuilder<CompositeAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CompositeDateHistogramAggregationSource dateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public final CompositeGeoTileGridAggregationSource geotileGrid() {
        return this.geotileGrid;
    }

    @Nullable
    public final CompositeHistogramAggregationSource histogram() {
        return this.histogram;
    }

    @Nullable
    public final CompositeTermsAggregationSource terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dateHistogram != null) {
            generator.writeKey("date_histogram");
            this.dateHistogram.serialize(generator, mapper);
        }
        if (this.geotileGrid != null) {
            generator.writeKey("geotile_grid");
            this.geotileGrid.serialize(generator, mapper);
        }
        if (this.histogram != null) {
            generator.writeKey("histogram");
            this.histogram.serialize(generator, mapper);
        }
        if (this.terms != null) {
            generator.writeKey("terms");
            this.terms.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCompositeAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dateHistogram, CompositeDateHistogramAggregationSource._DESERIALIZER, "date_histogram");
        op.add(Builder::geotileGrid, CompositeGeoTileGridAggregationSource._DESERIALIZER, "geotile_grid");
        op.add(Builder::histogram, CompositeHistogramAggregationSource._DESERIALIZER, "histogram");
        op.add(Builder::terms, CompositeTermsAggregationSource._DESERIALIZER, "terms");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.dateHistogram);
        result = 31 * result + Objects.hashCode(this.geotileGrid);
        result = 31 * result + Objects.hashCode(this.histogram);
        result = 31 * result + Objects.hashCode(this.terms);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeAggregationSource other = (CompositeAggregationSource)o;
        return Objects.equals(this.dateHistogram, other.dateHistogram) && Objects.equals(this.geotileGrid, other.geotileGrid) && Objects.equals(this.histogram, other.histogram) && Objects.equals(this.terms, other.terms);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CompositeAggregationSource> {
        @Nullable
        private CompositeDateHistogramAggregationSource dateHistogram;
        @Nullable
        private CompositeGeoTileGridAggregationSource geotileGrid;
        @Nullable
        private CompositeHistogramAggregationSource histogram;
        @Nullable
        private CompositeTermsAggregationSource terms;

        public Builder() {
        }

        private Builder(CompositeAggregationSource o) {
            this.dateHistogram = o.dateHistogram;
            this.geotileGrid = o.geotileGrid;
            this.histogram = o.histogram;
            this.terms = o.terms;
        }

        private Builder(Builder o) {
            this.dateHistogram = o.dateHistogram;
            this.geotileGrid = o.geotileGrid;
            this.histogram = o.histogram;
            this.terms = o.terms;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder dateHistogram(@Nullable CompositeDateHistogramAggregationSource value) {
            this.dateHistogram = value;
            return this;
        }

        @Nonnull
        public final Builder dateHistogram(Function<CompositeDateHistogramAggregationSource.Builder, ObjectBuilder<CompositeDateHistogramAggregationSource>> fn) {
            return this.dateHistogram(fn.apply(new CompositeDateHistogramAggregationSource.Builder()).build());
        }

        @Nonnull
        public final Builder geotileGrid(@Nullable CompositeGeoTileGridAggregationSource value) {
            this.geotileGrid = value;
            return this;
        }

        @Nonnull
        public final Builder geotileGrid(Function<CompositeGeoTileGridAggregationSource.Builder, ObjectBuilder<CompositeGeoTileGridAggregationSource>> fn) {
            return this.geotileGrid(fn.apply(new CompositeGeoTileGridAggregationSource.Builder()).build());
        }

        @Nonnull
        public final Builder histogram(@Nullable CompositeHistogramAggregationSource value) {
            this.histogram = value;
            return this;
        }

        @Nonnull
        public final Builder histogram(Function<CompositeHistogramAggregationSource.Builder, ObjectBuilder<CompositeHistogramAggregationSource>> fn) {
            return this.histogram(fn.apply(new CompositeHistogramAggregationSource.Builder()).build());
        }

        @Nonnull
        public final Builder terms(@Nullable CompositeTermsAggregationSource value) {
            this.terms = value;
            return this;
        }

        @Nonnull
        public final Builder terms(Function<CompositeTermsAggregationSource.Builder, ObjectBuilder<CompositeTermsAggregationSource>> fn) {
            return this.terms(fn.apply(new CompositeTermsAggregationSource.Builder()).build());
        }

        @Override
        @Nonnull
        public CompositeAggregationSource build() {
            this._checkSingleUse();
            return new CompositeAggregationSource(this);
        }
    }
}

