import { Command as $Command } from "@smithy/smithy-client";
import type { MetadataBearer as __MetadataBearer } from "@smithy/types";
import type { CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFrontClient";
import type { GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResult } from "../models/models_1";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetStreamingDistributionConfigCommand}.
 */
export interface GetStreamingDistributionConfigCommandInput extends GetStreamingDistributionConfigRequest {
}
/**
 * @public
 *
 * The output of {@link GetStreamingDistributionConfigCommand}.
 */
export interface GetStreamingDistributionConfigCommandOutput extends GetStreamingDistributionConfigResult, __MetadataBearer {
}
declare const GetStreamingDistributionConfigCommand_base: {
    new (input: GetStreamingDistributionConfigCommandInput): import("@smithy/smithy-client").CommandImpl<GetStreamingDistributionConfigCommandInput, GetStreamingDistributionConfigCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetStreamingDistributionConfigCommandInput): import("@smithy/smithy-client").CommandImpl<GetStreamingDistributionConfigCommandInput, GetStreamingDistributionConfigCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Get the configuration information about a streaming distribution.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFrontClient, GetStreamingDistributionConfigCommand } from "@aws-sdk/client-cloudfront"; // ES Modules import
 * // const { CloudFrontClient, GetStreamingDistributionConfigCommand } = require("@aws-sdk/client-cloudfront"); // CommonJS import
 * // import type { CloudFrontClientConfig } from "@aws-sdk/client-cloudfront";
 * const config = {}; // type is CloudFrontClientConfig
 * const client = new CloudFrontClient(config);
 * const input = { // GetStreamingDistributionConfigRequest
 *   Id: "STRING_VALUE", // required
 * };
 * const command = new GetStreamingDistributionConfigCommand(input);
 * const response = await client.send(command);
 * // { // GetStreamingDistributionConfigResult
 * //   StreamingDistributionConfig: { // StreamingDistributionConfig
 * //     CallerReference: "STRING_VALUE", // required
 * //     S3Origin: { // S3Origin
 * //       DomainName: "STRING_VALUE", // required
 * //       OriginAccessIdentity: "STRING_VALUE", // required
 * //     },
 * //     Aliases: { // Aliases
 * //       Quantity: Number("int"), // required
 * //       Items: [ // AliasList
 * //         "STRING_VALUE",
 * //       ],
 * //     },
 * //     Comment: "STRING_VALUE", // required
 * //     Logging: { // StreamingLoggingConfig
 * //       Enabled: true || false, // required
 * //       Bucket: "STRING_VALUE", // required
 * //       Prefix: "STRING_VALUE", // required
 * //     },
 * //     TrustedSigners: { // TrustedSigners
 * //       Enabled: true || false, // required
 * //       Quantity: Number("int"), // required
 * //       Items: [ // AwsAccountNumberList
 * //         "STRING_VALUE",
 * //       ],
 * //     },
 * //     PriceClass: "PriceClass_100" || "PriceClass_200" || "PriceClass_All" || "None",
 * //     Enabled: true || false, // required
 * //   },
 * //   ETag: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetStreamingDistributionConfigCommandInput - {@link GetStreamingDistributionConfigCommandInput}
 * @returns {@link GetStreamingDistributionConfigCommandOutput}
 * @see {@link GetStreamingDistributionConfigCommandInput} for command's `input` shape.
 * @see {@link GetStreamingDistributionConfigCommandOutput} for command's `response` shape.
 * @see {@link CloudFrontClientResolvedConfig | config} for CloudFrontClient's `config` shape.
 *
 * @throws {@link AccessDenied} (client fault)
 *  <p>Access denied.</p>
 *
 * @throws {@link NoSuchStreamingDistribution} (client fault)
 *  <p>The specified streaming distribution does not exist.</p>
 *
 * @throws {@link CloudFrontServiceException}
 * <p>Base exception class for all service exceptions from CloudFront service.</p>
 *
 *
 * @public
 */
export declare class GetStreamingDistributionConfigCommand extends GetStreamingDistributionConfigCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetStreamingDistributionConfigRequest;
            output: GetStreamingDistributionConfigResult;
        };
        sdk: {
            input: GetStreamingDistributionConfigCommandInput;
            output: GetStreamingDistributionConfigCommandOutput;
        };
    };
}
