import { Command as $Command } from "@smithy/smithy-client";
import type { MetadataBearer as __MetadataBearer } from "@smithy/types";
import type { CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFrontClient";
import type { ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResult } from "../models/models_1";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ListCloudFrontOriginAccessIdentitiesCommand}.
 */
export interface ListCloudFrontOriginAccessIdentitiesCommandInput extends ListCloudFrontOriginAccessIdentitiesRequest {
}
/**
 * @public
 *
 * The output of {@link ListCloudFrontOriginAccessIdentitiesCommand}.
 */
export interface ListCloudFrontOriginAccessIdentitiesCommandOutput extends ListCloudFrontOriginAccessIdentitiesResult, __MetadataBearer {
}
declare const ListCloudFrontOriginAccessIdentitiesCommand_base: {
    new (input: ListCloudFrontOriginAccessIdentitiesCommandInput): import("@smithy/smithy-client").CommandImpl<ListCloudFrontOriginAccessIdentitiesCommandInput, ListCloudFrontOriginAccessIdentitiesCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [ListCloudFrontOriginAccessIdentitiesCommandInput]): import("@smithy/smithy-client").CommandImpl<ListCloudFrontOriginAccessIdentitiesCommandInput, ListCloudFrontOriginAccessIdentitiesCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Lists origin access identities.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFrontClient, ListCloudFrontOriginAccessIdentitiesCommand } from "@aws-sdk/client-cloudfront"; // ES Modules import
 * // const { CloudFrontClient, ListCloudFrontOriginAccessIdentitiesCommand } = require("@aws-sdk/client-cloudfront"); // CommonJS import
 * // import type { CloudFrontClientConfig } from "@aws-sdk/client-cloudfront";
 * const config = {}; // type is CloudFrontClientConfig
 * const client = new CloudFrontClient(config);
 * const input = { // ListCloudFrontOriginAccessIdentitiesRequest
 *   Marker: "STRING_VALUE",
 *   MaxItems: Number("int"),
 * };
 * const command = new ListCloudFrontOriginAccessIdentitiesCommand(input);
 * const response = await client.send(command);
 * // { // ListCloudFrontOriginAccessIdentitiesResult
 * //   CloudFrontOriginAccessIdentityList: { // CloudFrontOriginAccessIdentityList
 * //     Marker: "STRING_VALUE", // required
 * //     NextMarker: "STRING_VALUE",
 * //     MaxItems: Number("int"), // required
 * //     IsTruncated: true || false, // required
 * //     Quantity: Number("int"), // required
 * //     Items: [ // CloudFrontOriginAccessIdentitySummaryList
 * //       { // CloudFrontOriginAccessIdentitySummary
 * //         Id: "STRING_VALUE", // required
 * //         S3CanonicalUserId: "STRING_VALUE", // required
 * //         Comment: "STRING_VALUE", // required
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param ListCloudFrontOriginAccessIdentitiesCommandInput - {@link ListCloudFrontOriginAccessIdentitiesCommandInput}
 * @returns {@link ListCloudFrontOriginAccessIdentitiesCommandOutput}
 * @see {@link ListCloudFrontOriginAccessIdentitiesCommandInput} for command's `input` shape.
 * @see {@link ListCloudFrontOriginAccessIdentitiesCommandOutput} for command's `response` shape.
 * @see {@link CloudFrontClientResolvedConfig | config} for CloudFrontClient's `config` shape.
 *
 * @throws {@link InvalidArgument} (client fault)
 *  <p>An argument is invalid.</p>
 *
 * @throws {@link CloudFrontServiceException}
 * <p>Base exception class for all service exceptions from CloudFront service.</p>
 *
 *
 * @public
 */
export declare class ListCloudFrontOriginAccessIdentitiesCommand extends ListCloudFrontOriginAccessIdentitiesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ListCloudFrontOriginAccessIdentitiesRequest;
            output: ListCloudFrontOriginAccessIdentitiesResult;
        };
        sdk: {
            input: ListCloudFrontOriginAccessIdentitiesCommandInput;
            output: ListCloudFrontOriginAccessIdentitiesCommandOutput;
        };
    };
}
