/**
 * @public
 */
export interface CreateTokenRequest {
    /**
     * <p>The unique identifier string for the client or application. This value comes from the
     *       result of the <a>RegisterClient</a> API.</p>
     * @public
     */
    clientId: string | undefined;
    /**
     * <p>A secret string generated for the client. This value should come from the persisted result
     *       of the <a>RegisterClient</a> API.</p>
     * @public
     */
    clientSecret: string | undefined;
    /**
     * <p>Supports the following OAuth grant types: Authorization Code, Device Code, and Refresh
     *       Token. Specify one of the following values, depending on the grant type that you want:</p>
     *          <p>* Authorization Code - <code>authorization_code</code>
     *          </p>
     *          <p>* Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     *          </p>
     *          <p>* Refresh Token - <code>refresh_token</code>
     *          </p>
     * @public
     */
    grantType: string | undefined;
    /**
     * <p>Used only when calling this API for the Device Code grant type. This short-lived code is
     *       used to identify this authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.</p>
     * @public
     */
    deviceCode?: string | undefined;
    /**
     * <p>Used only when calling this API for the Authorization Code grant type. The short-lived
     *       code is used to identify this authorization request.</p>
     * @public
     */
    code?: string | undefined;
    /**
     * <p>Used only when calling this API for the Refresh Token grant type. This token is used to
     *       refresh short-lived tokens, such as the access token, that might expire.</p>
     *          <p>For more information about the features and limitations of the current IAM Identity Center OIDC
     *       implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.</p>
     * @public
     */
    refreshToken?: string | undefined;
    /**
     * <p>The list of scopes for which authorization is requested. This parameter has no effect; the access token will always include all scopes configured during client registration.</p>
     * @public
     */
    scope?: string[] | undefined;
    /**
     * <p>Used only when calling this API for the Authorization Code grant type. This value
     *       specifies the location of the client or application that has registered to receive the
     *       authorization code.</p>
     * @public
     */
    redirectUri?: string | undefined;
    /**
     * <p>Used only when calling this API for the Authorization Code grant type. This value is
     *       generated by the client and presented to validate the original code challenge value the client
     *       passed at authorization time.</p>
     * @public
     */
    codeVerifier?: string | undefined;
}
/**
 * @public
 */
export interface CreateTokenResponse {
    /**
     * <p>A bearer token to access Amazon Web Services accounts and applications assigned to a user.</p>
     * @public
     */
    accessToken?: string | undefined;
    /**
     * <p>Used to notify the client that the returned token is an access token. The supported token
     *       type is <code>Bearer</code>.</p>
     * @public
     */
    tokenType?: string | undefined;
    /**
     * <p>Indicates the time in seconds when an access token will expire.</p>
     * @public
     */
    expiresIn?: number | undefined;
    /**
     * <p>A token that, if present, can be used to refresh a previously issued access token that
     *       might have expired.</p>
     *          <p>For more information about the features and limitations of the current IAM Identity Center OIDC
     *       implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.</p>
     * @public
     */
    refreshToken?: string | undefined;
    /**
     * <p>The <code>idToken</code> is not implemented or supported. For more information about the
     *       features and limitations of the current IAM Identity Center OIDC implementation, see
     *         <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.</p>
     *          <p>A JSON Web Token (JWT) that identifies who is associated with the issued access token.
     *     </p>
     * @public
     */
    idToken?: string | undefined;
}
