/**
 * ./src/classes/xdg.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Xdg: xdg-user-dirs, etc
 */
export default class Xdg {
    /**
     * Forza l'autologin per il nuovo utente (live) su diversi Display Manager
     */
    static autologin(newuser: string, chroot?: string): Promise<void>;
    /**
     * Create user dirs
     */
    static create(user: string, chroot: string, traduce?: boolean, verbose?: boolean): Promise<void>;
    static mk(chroot: string, path: string, verbose?: boolean): Promise<void>;
    /**
     * Copia della configurazione in /etc/skel
     */
    static skel(user: string, verbose?: boolean): Promise<void>;
    static traduce(xdg_dir?: string, traduce?: boolean): string;
}
