/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import net.sourceforge.plantuml.decoration.WithLinkType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;

public class TimeArrow
implements UDrawable {
    private final XPoint2D start;
    private final XPoint2D end;
    private final Display label;
    private final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final WithLinkType type;

    public static TimeArrow create(IntricatedPoint pt1, IntricatedPoint pt2, Display label, ISkinParam spriteContainer, WithLinkType type) {
        TimeArrow arrow1 = new TimeArrow(pt1.getPointA(), pt2.getPointA(), label, spriteContainer, type);
        TimeArrow arrow2 = new TimeArrow(pt1.getPointA(), pt2.getPointB(), label, spriteContainer, type);
        TimeArrow arrow3 = new TimeArrow(pt1.getPointB(), pt2.getPointA(), label, spriteContainer, type);
        TimeArrow arrow4 = new TimeArrow(pt1.getPointB(), pt2.getPointB(), label, spriteContainer, type);
        return TimeArrow.shorter(arrow1, arrow2, arrow3, arrow4);
    }

    private TimeArrow(XPoint2D start, XPoint2D end, Display label, ISkinParam skinParam, WithLinkType type) {
        this.start = start;
        this.type = type;
        this.end = end;
        this.label = label;
        this.skinParam = skinParam;
        this.styleBuilder = skinParam.getCurrentStyleBuilder();
    }

    private double getAngle() {
        return Math.atan2(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
    }

    private static TimeArrow shorter(TimeArrow arrow1, TimeArrow arrow2) {
        if (arrow1.len() < arrow2.len()) {
            return arrow1;
        }
        return arrow2;
    }

    private static TimeArrow shorter(TimeArrow arrow1, TimeArrow arrow2, TimeArrow arrow3, TimeArrow arrow4) {
        return TimeArrow.shorter(TimeArrow.shorter(arrow1, arrow2), TimeArrow.shorter(arrow3, arrow4));
    }

    private double len() {
        return this.start.distance(this.end);
    }

    public TimeArrow translate(UTranslate translate) {
        return new TimeArrow(translate.getTranslated(this.start), translate.getTranslated(this.end), this.label, this.skinParam, this.type);
    }

    public static XPoint2D onCircle(XPoint2D pt, double alpha) {
        double radius = 8.0;
        double x = pt.getX() - Math.sin(alpha) * 8.0;
        double y = pt.getY() - Math.cos(alpha) * 8.0;
        return new XPoint2D(x, y);
    }

    private FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet());
    }

    @Override
    public void drawU(UGraphic ug) {
        double angle = this.getAngle();
        ug = ug.apply(this.type.getSpecificColor()).apply(this.type.getUStroke());
        ULine line = new ULine(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
        ug.apply(UTranslate.point(this.start)).draw(line);
        double delta = 0.3490658503988659;
        XPoint2D pt1 = TimeArrow.onCircle(this.end, angle + 0.3490658503988659);
        XPoint2D pt2 = TimeArrow.onCircle(this.end, angle - 0.3490658503988659);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(pt1.getX(), pt1.getY());
        polygon.addPoint(pt2.getX(), pt2.getY());
        polygon.addPoint(this.end.getX(), this.end.getY());
        ug = ug.apply(this.type.getSpecificColor().bg());
        ug.draw(polygon);
        TextBlock textLabel = this.getTextBlock(this.label);
        double xText = (pt1.getX() + pt2.getX()) / 2.0;
        double yText = (pt1.getY() + pt2.getY()) / 2.0;
        if (this.start.getY() < this.end.getY()) {
            XDimension2D dimLabel = textLabel.calculateDimension(ug.getStringBounder());
            yText -= dimLabel.getHeight();
        }
        textLabel.drawU(ug.apply(new UTranslate(xText, yText)));
    }

    private TextBlock getTextBlock(Display display) {
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.arrow);
    }
}

