/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.common.syntax.psi.impl;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassLetter;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigDescribableElement;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValuePair;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Optional;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class EditorConfigPsiImplUtils {
    public static final String VALID_ESCAPES = " \r\n\t\\#;!?*[]{}";

    private EditorConfigPsiImplUtils() {
    }

    public static boolean isEscape(@NotNull EditorConfigCharClassLetter letter) {
        if (letter == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(0);
        }
        return letter.textContains('\\');
    }

    public static boolean isValidEscape(@NotNull EditorConfigCharClassLetter letter) {
        if (letter == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(1);
        }
        if (!letter.isEscape()) {
            return false;
        }
        int length = letter.getTextLength();
        if (length == 3) {
            return letter.textMatches("\\\r\n");
        }
        if (length != 2) {
            return false;
        }
        String text = letter.getText();
        if (text.charAt(0) != '\\') {
            return false;
        }
        return StringsKt.contains((CharSequence)VALID_ESCAPES, (char)text.charAt(1), (boolean)false);
    }

    @NotNull
    public static EditorConfigDescribableElement getFirst(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> first;
        if (pair == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(2);
        }
        if ((first = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).findFirst()).isEmpty()) {
            throw new IllegalStateException();
        }
        EditorConfigDescribableElement editorConfigDescribableElement = (EditorConfigDescribableElement)first.get();
        if (editorConfigDescribableElement == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(3);
        }
        return editorConfigDescribableElement;
    }

    @NotNull
    public static EditorConfigDescribableElement getSecond(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> second;
        if (pair == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(4);
        }
        if ((second = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).skip(1L).findFirst()).isEmpty()) {
            throw new IllegalStateException();
        }
        EditorConfigDescribableElement editorConfigDescribableElement = (EditorConfigDescribableElement)second.get();
        if (editorConfigDescribableElement == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(5);
        }
        return editorConfigDescribableElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "letter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editorconfig/common/syntax/psi/impl/EditorConfigPsiImplUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editorconfig/common/syntax/psi/impl/EditorConfigPsiImplUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecond";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEscape";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidEscape";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirst";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSecond";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

