/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.Dictionary;
import morfologik.stemming.WordData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.MorfologikTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.StringTools;

public abstract class BaseTagger
implements Tagger {
    private static final String MANUAL_ADDITIONS_FILE = "/added.txt";
    private static final String CUSTOM_MANUAL_ADDITIONS_FILE = "/added_custom.txt";
    private static final String MANUAL_REMOVALS_FILE = "/removed.txt";
    private static final String CUSTOM_MANUAL_REMOVALS_FILE = "/removed_custom.txt";
    protected final WordTagger wordTagger;
    protected final Locale locale;
    private final boolean tagLowercaseWithUppercase;
    private final String dictionaryPath;
    private final Dictionary dictionary;

    @NotNull
    public List<String> getManualAdditionsFileNames() {
        return Arrays.asList(this.locale.getLanguage() + MANUAL_ADDITIONS_FILE, this.locale.getLanguage() + CUSTOM_MANUAL_ADDITIONS_FILE);
    }

    @NotNull
    public List<String> getManualRemovalsFileNames() {
        return Arrays.asList(this.locale.getLanguage() + MANUAL_REMOVALS_FILE, this.locale.getLanguage() + CUSTOM_MANUAL_REMOVALS_FILE);
    }

    public BaseTagger(String filename, Locale locale) {
        this(filename, locale, true);
    }

    public BaseTagger(String filename, Locale locale, boolean tagLowercaseWithUppercase) {
        this(filename, locale, tagLowercaseWithUppercase, false);
    }

    public BaseTagger(String filename, Locale locale, boolean tagLowercaseWithUppercase, boolean internTags) {
        this.dictionaryPath = filename;
        this.locale = locale;
        this.tagLowercaseWithUppercase = tagLowercaseWithUppercase;
        this.dictionary = MorfologikSpeller.getDictionaryWithCaching(filename);
        this.wordTagger = this.initWordTagger(internTags);
    }

    public String getDictionaryPath() {
        return this.dictionaryPath;
    }

    public boolean overwriteWithManualTagger() {
        return false;
    }

    protected WordTagger getWordTagger() {
        return this.wordTagger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private WordTagger initWordTagger(boolean internTags) {
        MorfologikTagger morfologikTagger2 = new MorfologikTagger(this.dictionary, internTags);
        try {
            ManualTagger removalTagger = null;
            try (InputStream stream = null;){
                for (String file : this.getManualRemovalsFileNames()) {
                    for (URL url : JLanguageTool.getDataBroker().getFromResourceDirAsUrls(file)) {
                        if (stream == null) {
                            stream = url.openStream();
                            continue;
                        }
                        stream = new SequenceInputStream(stream, url.openStream());
                    }
                }
                if (stream != null) {
                    removalTagger = new ManualTagger(stream, internTags);
                }
            }
            stream = null;
            try {
                for (String file : this.getManualAdditionsFileNames()) {
                    for (URL url : JLanguageTool.getDataBroker().getFromResourceDirAsUrls(file)) {
                        if (stream == null) {
                            stream = url.openStream();
                            continue;
                        }
                        stream = new SequenceInputStream(stream, url.openStream());
                    }
                }
                if (stream != null) {
                    ManualTagger manualTagger = new ManualTagger(stream, internTags);
                    CombiningTagger combiningTagger = new CombiningTagger(morfologikTagger2, manualTagger, removalTagger, this.overwriteWithManualTagger());
                    return combiningTagger;
                }
                MorfologikTagger morfologikTagger = morfologikTagger2;
                return morfologikTagger;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load manual tagger data from " + this.getManualAdditionsFileNames(), e);
        }
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            List<AnalyzedToken> l = this.getAnalyzedTokens(word);
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    protected List<AnalyzedToken> getAnalyzedTokens(String word) {
        List<AnalyzedToken> upperTaggerTokens;
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.locale);
        boolean isLowercase = word.equals(lowerWord);
        boolean isMixedCase = StringTools.isMixedCase(word);
        List<AnalyzedToken> taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
        List<AnalyzedToken> lowerTaggerTokens = !isLowercase ? this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord)) : taggerTokens;
        this.addTokens(taggerTokens, result);
        if (!isLowercase && !isMixedCase) {
            this.addTokens(lowerTaggerTokens, result);
        }
        if (this.tagLowercaseWithUppercase && lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty() && isLowercase && !(upperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(StringTools.uppercaseFirstChar(word)))).isEmpty()) {
            this.addTokens(upperTaggerTokens, result);
        }
        if (result.isEmpty()) {
            List<AnalyzedToken> additionalTaggedTokens = this.additionalTags(word, this.getWordTagger());
            this.addTokens(additionalTaggedTokens, result);
        }
        if (result.isEmpty()) {
            result.add(new AnalyzedToken(word, null, null));
        }
        return result;
    }

    protected List<AnalyzedToken> asAnalyzedTokenList(String word, List<WordData> wdList) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        for (WordData wd : wdList) {
            aTokenList.add(this.asAnalyzedToken(word, wd));
        }
        return aTokenList;
    }

    protected List<AnalyzedToken> asAnalyzedTokenListForTaggedWords(String word, List<TaggedWord> taggedWords) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            aTokenList.add(this.asAnalyzedToken(word, taggedWord));
        }
        return aTokenList;
    }

    protected AnalyzedToken asAnalyzedToken(String word, WordData wd) {
        String tag = StringTools.asString(wd.getTag());
        if (this.dictionary.metadata.isFrequencyIncluded() && tag.length() > 1) {
            tag = tag.substring(0, tag.length() - 1);
        }
        return new AnalyzedToken(word, tag, StringTools.asString(wd.getStem()));
    }

    private AnalyzedToken asAnalyzedToken(String word, TaggedWord taggedWord) {
        return new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma());
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                l.add(at);
            }
        }
    }

    @Override
    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    @Override
    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        return null;
    }
}

