/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import org.jetbrains.annotations.NotNull;

public class AddEncodingQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myDefaultEncoding;
    private final int myEncodingFormatIndex;

    public AddEncodingQuickFix(String defaultEncoding, int encodingFormatIndex) {
        this.myDefaultEncoding = defaultEncoding;
        this.myEncodingFormatIndex = encodingFormatIndex;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.add.encoding", new Object[0]);
        if (string == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiFile file;
        if (project == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(3);
        }
        if ((file = element.getContainingFile()) == null) {
            return;
        }
        PsiElement firstLine = file.getFirstChild();
        if (firstLine instanceof PsiComment && firstLine.getText().startsWith("#!")) {
            firstLine = firstLine.getNextSibling();
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        String commentText = String.format(PyEncodingUtil.ENCODING_FORMAT_PATTERN[this.myEncodingFormatIndex], this.myDefaultEncoding);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance((Project)project);
        PsiComment encodingComment = (PsiComment)elementGenerator.createFromText(languageLevel, PsiComment.class, commentText);
        if ((encodingComment = (PsiComment)file.addBefore((PsiElement)encodingComment, firstLine)).getNextSibling() == null || !encodingComment.getNextSibling().textContains('\n')) {
            file.addAfter((PsiElement)elementGenerator.createFromText(languageLevel, PsiWhiteSpace.class, "\n"), (PsiElement)encodingComment);
        }
        Document document = file.getFileDocument();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        int insertedLineNumber = document.getLineNumber(encodingComment.getTextOffset());
        updater.moveCaretTo(document.getLineStartOffset(insertedLineNumber + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

