/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PTee;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.TeeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.TeeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTee})
public final class TeeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TeeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TeeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PTee self, Object state, @Bind Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached CastToJavaIntLossyNode castToIntNode, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            if (!(state instanceof PTuple) || (Integer)lenNode.execute(frame, state) != 2) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "2-tuple");
            }
            Object dataObject = getItemNode.execute(frame, state, 0);
            if (!(dataObject instanceof PTeeDataObject)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "_tee_dataobject");
            }
            self.setDataObj((PTeeDataObject)dataObject);
            Object secondElement = getItemNode.execute(frame, state, 1);
            int index = 0;
            try {
                index = castToIntNode.execute(inliningTarget, secondElement);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED_GOT, secondElement);
            }
            if (index < 0 || index > 128) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            self.setIndex(index);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PTee self, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClass.execute(inliningTarget, self);
            PTuple tuple1 = PFactory.createTuple(language, new Object[]{PFactory.createEmptyTuple(language)});
            PTuple tuple2 = PFactory.createTuple(language, new Object[]{self.getDataobj(), self.getIndex()});
            return PFactory.createTuple(language, new Object[]{type, tuple1, tuple2});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @ImportStatic(value={TeeDataObjectBuiltins.class})
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object doIt(VirtualFrame frame, PTee self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile indexConditionProfile, @Cached PyIterNextNode nextNode, @Cached PRaiseNode raiseNode) {
            if (indexConditionProfile.profile(inliningTarget, self.getIndex() >= 128)) {
                self.setDataObj(self.getDataobj().jumplink(language));
                self.setIndex(0);
            }
            Object value = self.getDataobj().getItem(frame, inliningTarget, self.getIndex(), nextNode, raiseNode);
            self.setIndex(self.getIndex() + 1);
            return value;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PTee self) {
            return self;
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static PTee copy(PTee self, @Bind PythonLanguage language) {
            return PFactory.createTee(language, self.getDataobj(), self.getIndex());
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NewNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static PTee teeFromIterable(VirtualFrame frame, Object cls, Object iterable, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached InlinedConditionProfile isTeeInstanceProfile, @Bind PythonLanguage language) {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            if (isTeeInstanceProfile.profile(inliningTarget, it instanceof PTee)) {
                return CopyNode.copy((PTee)it, language);
            }
            PTeeDataObject dataObj = PFactory.createTeeDataObject(language, it);
            return PFactory.createTee(language, dataObj, 0);
        }

        @NeverDefault
        protected LookupAndCallUnaryNode createCopyNode() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___COPY__);
        }
    }
}

