/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.typing.PTypeVar;
import com.oracle.graal.python.builtins.objects.typing.TypeVarBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.typing.TypeVarBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.TypeVarBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTypeVar})
public final class TypeVarBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TypeVarBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypeVarBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        static final TruffleString T_MAKE_UNION = PythonUtils.tsLiteral("_make_union");

        OrNode() {
        }

        @Specialization
        static Object union(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_MAKE_UNION, self, other);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PTypeVar self) {
            return self.name;
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PTypeVar self, Object bases, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SUBCLASS_AN_INSTANCE_OF_TYPEVAR);
        }
    }

    @Builtin(name="__typing_subst__", minNumOfPositionalArgs=2, parameterNames={"$self", "arg"})
    @GenerateNodeFactory
    static abstract class TypingSubstNode
    extends PythonBinaryBuiltinNode {
        static final TruffleString T_TYPEVAR_SUBST = PythonUtils.tsLiteral("_typevar_subst");

        TypingSubstNode() {
        }

        @Specialization
        static Object doTypingSubst(VirtualFrame frame, PTypeVar self, Object arg, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_TYPEVAR_SUBST, self, arg);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization(guards={"self.inferVariance"})
        static TruffleString reprInferVariance(PTypeVar self) {
            return self.name;
        }

        @Specialization(guards={"!self.inferVariance"})
        static TruffleString repr(PTypeVar self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            char variance = self.covariant ? (char)'+' : (self.contravariant ? (char)'-' : '~');
            return simpleTruffleStringFormatNode.format("%c%s", Character.valueOf(variance), self.name);
        }
    }

    @Builtin(name="__constraints__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetConstraintsNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.constraints != null"})
        static Object doEvaluated(PTypeVar self) {
            return self.constraints;
        }

        @Specialization(guards={"self.constraints == null"})
        static Object doEvaluate(VirtualFrame frame, PTypeVar self, @Cached CallNode callNode) {
            assert (self.evaluateConstraints != null);
            self.constraints = callNode.execute((Frame)frame, self.evaluateConstraints, new Object[0]);
            self.evaluateConstraints = null;
            return self.constraints;
        }
    }

    @Builtin(name="__bound__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetBoundNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.bound != null"})
        static Object doEvaluated(PTypeVar self) {
            return self.bound;
        }

        @Specialization(guards={"self.bound == null"})
        static Object doEvaluate(VirtualFrame frame, PTypeVar self, @Cached CallNode callNode) {
            assert (self.evaluateBound != null);
            self.bound = callNode.execute((Frame)frame, self.evaluateBound, new Object[0]);
            self.evaluateBound = null;
            return self.bound;
        }
    }

    @Builtin(name="__infer_variance__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetInferVarianceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doInferVariance(PTypeVar self) {
            return self.inferVariance;
        }
    }

    @Builtin(name="__contravariant__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetContravariantNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doContravariant(PTypeVar self) {
            return self.contravariant;
        }
    }

    @Builtin(name="__covariant__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCovariantNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doCovariant(PTypeVar self) {
            return self.covariant;
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doName(PTypeVar self) {
            return self.name;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="TypeVar", minNumOfPositionalArgs=2, takesVarArgs=true, parameterNames={"$cls", "name"}, keywordOnlyNames={"bound", "covariant", "contravariant", "infer_variance"}, needsFrame=true, alwaysNeedsCallerFrame=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="covariant", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="contravariant", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="infer_variance", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class TypeVarNode
    extends PythonClinicBuiltinNode {
        TypeVarNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TypeVarBuiltinsClinicProviders.TypeVarNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PTypeVar newTypeVar(VirtualFrame frame, Object cls, TruffleString name, Object[] constraints, Object bound, boolean covariant, boolean contravariant, boolean inferVariance, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypingModuleBuiltins.CheckBoundNode checkBoundNode, @Cached TypingModuleBuiltins.CallerNode callerNode, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode, @Cached PyObjectSetAttr setAttrNode) {
            PTuple constraintsTuple;
            if (covariant && contravariant) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.BIVARIANT_TYPES_ARE_NOT_SUPPORTED);
            }
            if (inferVariance && (covariant || contravariant)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.VARIANCE_CANNOT_BE_SPECIFIED_WITH_INFER_VARIANCE);
            }
            Object boundChecked = checkBoundNode.execute(frame, inliningTarget, bound);
            if (constraints.length == 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.A_SINGLE_CONSTRAINT_IS_NOT_ALLOWED);
            }
            if (constraints.length == 0) {
                constraintsTuple = PFactory.createEmptyTuple(language);
            } else {
                if (boundChecked != PNone.NONE) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CONSTRAINTS_CANNOT_BE_COMBINED_WITH_BOUND);
                }
                constraintsTuple = PFactory.createTuple(language, constraints);
            }
            Object module = callerNode.execute(frame, inliningTarget);
            PTypeVar result = PFactory.createTypeVar(language, cls, getInstanceShape.execute(cls), name, boundChecked, null, constraintsTuple, null, covariant, contravariant, inferVariance);
            setAttrNode.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___MODULE__, module);
            return result;
        }
    }
}

