/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.expression.BinaryOp;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.object.IsNodeGen;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@GenerateUncached
@OperationProxy.Proxyable
@GenerateInline(value=false)
public abstract class IsNode
extends Node
implements BinaryOp {
    protected abstract boolean executeInternal(Object var1, Object var2);

    protected abstract boolean executeInternal(boolean var1, Object var2);

    @Override
    public final Object execute(VirtualFrame frame, Object left, Object right) {
        return this.execute(left, right);
    }

    public final boolean execute(Object left, Object right) {
        return left == right || this.executeInternal(left, right);
    }

    public boolean isTrue(Object object) {
        return this.executeInternal(true, object);
    }

    public boolean isFalse(Object object) {
        return this.executeInternal(false, object);
    }

    @Specialization
    public static boolean doBB(boolean left, boolean right) {
        return left == right;
    }

    @Specialization
    public static boolean doBP(boolean left, PInt right, @Bind Node inliningTarget) {
        PythonContext core = PythonContext.get(inliningTarget);
        if (left) {
            return right == core.getTrue();
        }
        return right == core.getFalse();
    }

    @Specialization
    public static boolean doII(int left, int right) {
        return left == right;
    }

    @Specialization
    public static boolean doIL(int left, long right) {
        return (long)left == right;
    }

    @Specialization
    public static boolean doIP(int left, PInt right, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, right)) {
            try {
                return right.intValueExact() == left;
            }
            catch (OverflowException e) {
                return false;
            }
        }
        return false;
    }

    @Specialization
    public static boolean doLI(long left, int right) {
        return left == (long)right;
    }

    @Specialization
    public static boolean doLL(long left, long right) {
        return left == right;
    }

    @Specialization
    public static boolean doLP(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, right)) {
            try {
                return left == right.longValueExact();
            }
            catch (OverflowException e) {
                return false;
            }
        }
        return false;
    }

    @Specialization
    public static boolean doDD(double left, double right) {
        return left == right || Double.doubleToRawLongBits(left) == Double.doubleToRawLongBits(right);
    }

    @Specialization
    public static boolean doPB(PInt left, boolean right, @Bind Node inliningTarget) {
        return IsNode.doBP(right, left, inliningTarget);
    }

    @Specialization
    public static boolean doPI(PInt left, int right, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        return IsNode.doIP(right, left, inliningTarget, isBuiltin);
    }

    @Specialization
    public static boolean doPL(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        return IsNode.doLP(right, left, inliningTarget, isBuiltin);
    }

    @Specialization
    public static boolean doCT(PythonBuiltinClass left, PythonBuiltinClassType right) {
        return left.getType() == right;
    }

    @Specialization
    public static boolean doTC(PythonBuiltinClassType left, PythonBuiltinClass right) {
        return right.getType() == left;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    public static boolean doNative(PythonAbstractNativeObject left, PythonAbstractNativeObject right, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary interop) {
        return interop.isIdentical((Object)left, (Object)right, interop);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    public static boolean doCode(PCode left, PCode right, @Bind Node inliningTarget, @Cached CodeNodes.GetCodeCallTargetNode getCt) {
        if (left != right) {
            RootCallTarget leftCt = getCt.execute(inliningTarget, left);
            RootCallTarget rightCt = getCt.execute(inliningTarget, right);
            if (leftCt != null && rightCt != null) {
                RootNode leftRootNode = leftCt.getRootNode();
                RootNode rightRootNode = rightCt.getRootNode();
                if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                    PRootNode l;
                    if (leftRootNode instanceof PBytecodeDSLGeneratorFunctionRootNode) {
                        l = (PBytecodeDSLGeneratorFunctionRootNode)leftRootNode;
                        leftRootNode = ((PBytecodeDSLGeneratorFunctionRootNode)l).getBytecodeRootNode();
                    }
                    if (rightRootNode instanceof PBytecodeDSLGeneratorFunctionRootNode) {
                        PBytecodeDSLGeneratorFunctionRootNode r = (PBytecodeDSLGeneratorFunctionRootNode)rightRootNode;
                        rightRootNode = r.getBytecodeRootNode();
                    }
                    if (leftRootNode instanceof PBytecodeDSLRootNode) {
                        l = (PBytecodeDSLRootNode)leftRootNode;
                        if (rightRootNode instanceof PBytecodeDSLRootNode) {
                            PBytecodeDSLRootNode r = (PBytecodeDSLRootNode)rightRootNode;
                            return ((PBytecodeDSLRootNode)l).getCodeUnit() == r.getCodeUnit();
                        }
                    }
                } else {
                    PRootNode l;
                    if (leftRootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                        l = (PBytecodeGeneratorFunctionRootNode)leftRootNode;
                        leftRootNode = ((PBytecodeGeneratorFunctionRootNode)l).getBytecodeRootNode();
                    }
                    if (rightRootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                        PBytecodeGeneratorFunctionRootNode r = (PBytecodeGeneratorFunctionRootNode)rightRootNode;
                        rightRootNode = r.getBytecodeRootNode();
                    }
                    if (leftRootNode instanceof PBytecodeRootNode) {
                        l = (PBytecodeRootNode)leftRootNode;
                        if (rightRootNode instanceof PBytecodeRootNode) {
                            PBytecodeRootNode r = (PBytecodeRootNode)rightRootNode;
                            return ((PBytecodeRootNode)l).getCodeUnit() == r.getCodeUnit();
                        }
                    }
                }
                return leftRootNode == rightRootNode;
            }
            return false;
        }
        return true;
    }

    public static boolean someIsNone(Object left, Object right) {
        return PGuards.isPNone(left) || PGuards.isPNone(right);
    }

    @Specialization(guards={"someIsNone(left, right)"})
    public static boolean doPNone(Object left, Object right, @Bind Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        if (left == right) {
            return true;
        }
        return IsNode.doPNoneSlowpath(left, right, inliningTarget, isForeignObjectNode, lib);
    }

    @HostCompilerDirectives.InliningCutoff
    private static boolean doPNoneSlowpath(Object left, Object right, Node inliningTarget, IsForeignObjectNode isForeignObjectNode, InteropLibrary lib) {
        if (isForeignObjectNode.execute(inliningTarget, left)) {
            return lib.isNull(left);
        }
        if (isForeignObjectNode.execute(inliningTarget, right)) {
            return lib.isNull(right);
        }
        return false;
    }

    @Specialization
    public static boolean doPString(PString left, PString right, @Bind Node inliningTarget, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached StringNodes.IsInternedStringNode isInternedStringNode, @Cached TruffleString.EqualNode equalNode) {
        if (isInternedStringNode.execute(inliningTarget, left) && isInternedStringNode.execute(inliningTarget, right)) {
            return equalNode.execute((AbstractTruffleString)materializeNode.execute(inliningTarget, left), (AbstractTruffleString)materializeNode.execute(inliningTarget, right), PythonUtils.TS_ENCODING);
        }
        return left == right;
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    public static boolean doOther(Object left, Object right, @Bind Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        if (left == right) {
            return true;
        }
        if (isForeignObjectNode.execute(inliningTarget, left)) {
            return lib.isIdentical(left, right, lib);
        }
        return false;
    }

    @NeverDefault
    public static IsNode create() {
        return IsNodeGen.create();
    }

    public static IsNode getUncached() {
        return IsNodeGen.getUncached();
    }
}

