/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class MroSequenceStorage
extends ArrayBasedSequenceStorage {
    private final TruffleString className;
    private final CyclicAssumption lookupStableAssumption;
    private final Map<TruffleString, List<Assumption>> attributesInMROFinalAssumptions;
    private boolean hasAttributesInMROFinalAssumptions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonAbstractClass[] values;
    private NativeSequenceStorage nativeMirror;
    private static final Predicate<List<Assumption>> REMOVE_IF_LARGE = new Predicate<List<Assumption>>(){

        @Override
        public boolean test(List<Assumption> assumptions) {
            return MroSequenceStorage.invalidateAttributesInMROFinalAssumptions(assumptions, "");
        }
    };

    @CompilerDirectives.TruffleBoundary
    public MroSequenceStorage(TruffleString className, PythonAbstractClass[] elements) {
        this.className = className;
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
        this.lookupStableAssumption = new CyclicAssumption(className.toJavaStringUncached());
        this.attributesInMROFinalAssumptions = new HashMap<TruffleString, List<Assumption>>();
    }

    @CompilerDirectives.TruffleBoundary
    public MroSequenceStorage(TruffleString className, int capacity) {
        this.className = className;
        this.values = new PythonAbstractClass[capacity];
        this.capacity = capacity;
        this.length = 0;
        this.lookupStableAssumption = new CyclicAssumption(className.toJavaStringUncached());
        this.attributesInMROFinalAssumptions = new HashMap<TruffleString, List<Assumption>>();
    }

    public PythonAbstractClass getPythonClassItemNormalized(int idx) {
        return this.values[idx];
    }

    public TruffleString getClassName() {
        return this.className;
    }

    @Override
    public MroSequenceStorage createEmpty(int newCapacity) {
        return new MroSequenceStorage(this.getClassName(), newCapacity);
    }

    public PythonAbstractClass[] getInternalClassArray() {
        return this.values;
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return this.getCopyOfInternalArray();
    }

    public Object[] getCopyOfInternalArray() {
        return PythonUtils.arrayCopyOf(this.values, this.length);
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Generic;
    }

    public Assumption getLookupStableAssumption() {
        return this.lookupStableAssumption.getAssumption();
    }

    public Assumption createAttributeInMROFinalAssumption(TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Assumption> attrAssumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, null);
        if (attrAssumptions == null) {
            attrAssumptions = new ArrayList<Assumption>();
            this.hasAttributesInMROFinalAssumptions = true;
            this.attributesInMROFinalAssumptions.put(name, attrAssumptions);
        }
        Assumption assumption = Truffle.getRuntime().createAssumption(name.toString());
        attrAssumptions.add(assumption);
        return assumption;
    }

    public void addAttributeInMROFinalAssumption(TruffleString name, Assumption assumption) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Assumption> attrAssumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, null);
        if (attrAssumptions == null) {
            attrAssumptions = new ArrayList<Assumption>();
            this.hasAttributesInMROFinalAssumptions = true;
            this.attributesInMROFinalAssumptions.put(name, attrAssumptions);
        }
        attrAssumptions.add(assumption);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean invalidateAttributeInMROFinalAssumptions(TruffleString name) {
        List<Assumption> assumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, Collections.emptyList());
        if (!assumptions.isEmpty()) {
            if (MroSequenceStorage.invalidateAttributesInMROFinalAssumptions(assumptions, String.valueOf(this.getClassName()) + "." + String.valueOf(name))) {
                this.attributesInMROFinalAssumptions.remove(name);
            }
            return true;
        }
        return false;
    }

    public void lookupChanged() {
        CompilerAsserts.neverPartOfCompilation();
        this.attributesInMROFinalAssumptions.values().removeIf(REMOVE_IF_LARGE);
        this.lookupStableAssumption.invalidate();
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean invalidateAttributesInMROFinalAssumptions(List<Assumption> list, String reason) {
        int n = list.size();
        if (n > 0) {
            for (Assumption assumption : list) {
                assumption.invalidate(reason);
            }
        }
        if (n < 16) {
            list.clear();
            return false;
        }
        return true;
    }

    public boolean hasAttributeInMROFinalAssumptions() {
        return this.hasAttributesInMROFinalAssumptions;
    }

    public NativeSequenceStorage getNativeMirror() {
        return this.nativeMirror;
    }

    public void setNativeMirror(NativeSequenceStorage nativeMirror) {
        this.nativeMirror = nativeMirror;
    }

    public boolean isNative() {
        return this.nativeMirror != null;
    }
}

