/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=InteropLibrary.class)
public class PFloat
extends PythonBuiltinObject {
    protected final double value;

    public PFloat(Object clazz, Shape instanceShape, double value) {
        super(clazz, instanceShape);
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    @ExportMessage.Ignore
    public boolean equals(Object obj) {
        return obj != null && PFloat.class == obj.getClass() && this.value == ((PFloat)obj).getValue();
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return Double.toString(this.value);
    }

    public boolean isNative() {
        return this.getNativeWrapper() != null && this.getNativeWrapper().isNative();
    }

    public static PFloat create(PythonLanguage lang, double value) {
        return PFloat.create((Object)PythonBuiltinClassType.PFloat, PythonBuiltinClassType.PFloat.getInstanceShape(lang), value);
    }

    public static PFloat create(Object cls, Shape instanceShape, double value) {
        return new PFloat(cls, instanceShape, value);
    }

    public static int compare(double x, double y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static boolean areIdentical(double x, double y) {
        return x == y || Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
    }

    @ExportMessage
    public boolean isNumber() {
        return true;
    }

    @ExportMessage
    boolean fitsInFloat(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInFloat((Object)this.value);
    }

    @ExportMessage
    float asFloat(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asFloat((Object)this.value);
    }

    @ExportMessage
    public boolean fitsInDouble() {
        return true;
    }

    @ExportMessage
    public double asDouble() {
        return this.getValue();
    }

    @ExportMessage
    boolean fitsInByte(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInByte((Object)this.value);
    }

    @ExportMessage
    byte asByte(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asByte((Object)this.value);
    }

    @ExportMessage
    boolean fitsInShort(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInShort((Object)this.value);
    }

    @ExportMessage
    short asShort(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asShort((Object)this.value);
    }

    @ExportMessage
    boolean fitsInInt(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInInt((Object)this.value);
    }

    @ExportMessage
    int asInt(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asInt((Object)this.value);
    }

    @ExportMessage
    boolean fitsInLong(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInLong((Object)this.value);
    }

    @ExportMessage
    long asLong(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asLong((Object)this.value);
    }
}

