/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyLongCopy;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyNumberIndexNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3);

    public static Object executeUncached(Object object) {
        return PyNumberIndexNodeGen.getUncached().execute(null, null, object);
    }

    @Specialization
    static int doInt(int object) {
        return object;
    }

    @Specialization
    static long doLong(long object) {
        return object;
    }

    @Specialization(guards={"isBuiltinPInt(object)"})
    static PInt doPInt(PInt object) {
        return object;
    }

    @Fallback
    static Object doCallIndex(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callIndex, @Cached(inline=false) IsSubtypeNode isSubtype, @Cached PRaiseNode raiseNode, @Cached PyLongCheckExactNode checkNode, @Cached CheckIndexResultNotInt checkResult, @Cached PyLongCopy copy) {
        Object type = getClassNode.execute(inliningTarget, object);
        if (isSubtype.execute(type, (Object)PythonBuiltinClassType.PInt)) {
            return copy.execute(inliningTarget, object);
        }
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.nb_index() == null) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, object);
        }
        Object result = callIndex.execute(frame, inliningTarget, slots.nb_index(), object);
        if (checkNode.execute(inliningTarget, result)) {
            return result;
        }
        return PyNumberIndexNode.checkResult(frame, result, object, checkResult);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object checkResult(VirtualFrame frame, Object result, Object object, CheckIndexResultNotInt checkResult) {
        return checkResult.execute(frame, object, result);
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CheckIndexResultNotInt
    extends Node {
        CheckIndexResultNotInt() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object original, Object result, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtype, @Cached PRaiseNode raiseNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PyLongCopy copy) {
            if (!isSubtype.execute(getClassNode.execute(inliningTarget, result), (Object)PythonBuiltinClassType.PInt)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, result);
            }
            warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, original, SpecialMethodNames.T___INDEX__, "int", result, "int");
            return copy.execute(inliningTarget, result);
        }
    }
}

