/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.zlib.JavaCompress;
import com.oracle.graal.python.builtins.modules.zlib.JavaDecompress;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.zlib.ZlibNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

@CoreFunctions(defineModule="zlib")
public final class ZLibModuleBuiltins
extends PythonBuiltins {
    protected static final String J_ZLIB = "zlib";
    protected static final TruffleString T_ZLIB = PythonUtils.tsLiteral("zlib");
    private static final TruffleString T_JDK_ZLIB_VERSION = PythonUtils.tsLiteral("1.2.11");
    public static final int Z_NO_FLUSH = 0;
    public static final int Z_PARTIAL_FLUSH = 1;
    public static final int Z_SYNC_FLUSH = 2;
    public static final int Z_FULL_FLUSH = 3;
    public static final int Z_FINISH = 4;
    public static final int Z_BLOCK = 5;
    public static final int Z_TREES = 6;
    public static final int Z_NO_COMPRESSION = 0;
    public static final int Z_BEST_SPEED = 1;
    public static final int Z_BEST_COMPRESSION = 9;
    public static final int Z_DEFAULT_COMPRESSION = -1;
    public static final int Z_FILTERED = 1;
    public static final int Z_HUFFMAN_ONLY = 2;
    public static final int Z_RLE = 3;
    public static final int Z_FIXED = 4;
    public static final int Z_DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    protected static final int MAX_WBITS = 15;
    protected static final int DEF_MEM_LEVEL = 8;
    protected static final int DEF_BUF_SIZE = 16384;
    protected static final byte[] EMPTY_BYTE_ARRAY = PythonUtils.EMPTY_BYTE_ARRAY;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZLibModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("Z_NO_COMPRESSION", (Object)0);
        this.addBuiltinConstant("Z_BEST_SPEED", (Object)1);
        this.addBuiltinConstant("Z_BEST_COMPRESSION", (Object)9);
        this.addBuiltinConstant("Z_DEFAULT_COMPRESSION", (Object)-1);
        this.addBuiltinConstant("Z_FILTERED", (Object)1);
        this.addBuiltinConstant("Z_HUFFMAN_ONLY", (Object)2);
        this.addBuiltinConstant("Z_RLE", (Object)3);
        this.addBuiltinConstant("Z_FIXED", (Object)4);
        this.addBuiltinConstant("Z_DEFAULT_STRATEGY", (Object)0);
        this.addBuiltinConstant("Z_NO_FLUSH", (Object)0);
        this.addBuiltinConstant("Z_SYNC_FLUSH", (Object)2);
        this.addBuiltinConstant("Z_FULL_FLUSH", (Object)3);
        this.addBuiltinConstant("Z_FINISH", (Object)4);
        this.addBuiltinConstant("DEFLATED", (Object)8);
        this.addBuiltinConstant("MAX_WBITS", (Object)15);
        this.addBuiltinConstant("DEF_MEM_LEVEL", (Object)8);
        this.addBuiltinConstant("DEF_BUF_SIZE", (Object)16384);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        NFIZlibSupport zlibSupport = core.getContext().getNFIZlibSupport();
        PythonModule zlibModule = core.lookupBuiltinModule(T_ZLIB);
        TruffleString ver = T_JDK_ZLIB_VERSION;
        TruffleString rtver = T_JDK_ZLIB_VERSION;
        if (zlibSupport.isAvailable()) {
            try {
                ver = ZLibModuleBuiltins.asString(zlibSupport.zlibVersion());
                rtver = ZLibModuleBuiltins.asString(zlibSupport.zlibRuntimeVersion());
                zlibModule.setAttribute(PythonUtils.tsLiteral("Z_PARTIAL_FLUSH"), 1);
                zlibModule.setAttribute(PythonUtils.tsLiteral("Z_BLOCK"), 5);
                zlibModule.setAttribute(PythonUtils.tsLiteral("Z_TREES"), 6);
            }
            catch (NativeLibrary.NativeLibraryCannotBeLoaded e) {
                zlibSupport.notAvailable();
            }
        }
        zlibModule.setAttribute(PythonUtils.tsLiteral("ZLIB_VERSION"), ver);
        zlibModule.setAttribute(PythonUtils.tsLiteral("ZLIB_RUNTIME_VERSION"), rtver);
    }

    private static TruffleString asString(Object o) {
        if (o != null) {
            try {
                return InteropLibrary.getUncached().asTruffleString(o).switchEncodingUncached(PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        return null;
    }

    @Builtin(name="decompressobj", parameterNames={"wbits", "zdict"})
    @ArgumentsClinic(value={@ArgumentClinic(name="wbits", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.MAX_WBITS", useDefaultForNone=true), @ArgumentClinic(name="zdict", conversionClass=ExpectByteLikeNode.class, defaultValue="ZLibModuleBuiltins.EMPTY_BYTE_ARRAY", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class DecompressObjNode
    extends PythonClinicBuiltinNode {
        DecompressObjNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.DecompressObjNodeClinicProviderGen.INSTANCE;
        }

        @NonIdempotent
        protected boolean useNative() {
            return PythonContext.get(this).getNFIZlibSupport().isAvailable();
        }

        protected static boolean isValidWBitRange(int wbits) {
            return wbits < -7 || wbits > 7 && wbits <= 15 || wbits > 24 && wbits <= 31;
        }

        @Specialization(guards={"useNative()"})
        static Object doNative(int wbits, byte[] zdict, @Bind Node inliningTarget, @Bind PythonContext context, @Cached NativeLibrary.InvokeNativeFunction createCompObject, @Cached NativeLibrary.InvokeNativeFunction decompressObjInit, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
            Object zst = zlibSupport.createCompObject(createCompObject);
            int err = zdict.length > 0 ? zlibSupport.decompressObjInitWithDict(zst, wbits, zdict, zdict.length, decompressObjInit) : zlibSupport.decompressObjInit(zst, wbits, decompressObjInit);
            if (err != 0) {
                errorHandling.execute(inliningTarget, zst, err, zlibSupport, true);
            }
            return PFactory.createNativeZLibCompObjectDecompress(context.getLanguage(inliningTarget), zst, zlibSupport);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!useNative()", "isValidWBitRange(wbits)"})
        static Object doJava(int wbits, byte[] zdict) {
            boolean isRAW = wbits < 0;
            PythonLanguage language = PythonLanguage.get(null);
            JavaDecompress obj = PFactory.createJavaZLibCompObjectDecompress(language, wbits, zdict);
            if (isRAW) {
                obj.setDictionary();
            }
            obj.setUnusedData(PFactory.createEmptyBytes(language));
            obj.setUnconsumedTail(PFactory.createEmptyBytes(language));
            return obj;
        }

        @Specialization(guards={"!useNative()", "!isValidWBitRange(wbits)"})
        static Object invalid(int wbits, byte[] zdict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_INITIALIZATION_OPTION);
        }
    }

    @Builtin(name="compressobj", parameterNames={"level", "method", "wbits", "memLevel", "strategy", "zdict"})
    @ImportStatic(value={ZLibModuleBuiltins.class})
    @ArgumentsClinic(value={@ArgumentClinic(name="level", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="method", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.DEFLATED", useDefaultForNone=true), @ArgumentClinic(name="wbits", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.MAX_WBITS", useDefaultForNone=true), @ArgumentClinic(name="memLevel", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.DEF_MEM_LEVEL", useDefaultForNone=true), @ArgumentClinic(name="strategy", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.Z_DEFAULT_STRATEGY", useDefaultForNone=true), @ArgumentClinic(name="zdict", conversionClass=ExpectByteLikeNode.class, defaultValue="ZLibModuleBuiltins.EMPTY_BYTE_ARRAY", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class CompressObjNode
    extends PythonClinicBuiltinNode {
        CompressObjNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.CompressObjNodeClinicProviderGen.INSTANCE;
        }

        @NonIdempotent
        protected boolean useNative() {
            return PythonContext.get(this).getNFIZlibSupport().isAvailable();
        }

        protected static boolean isValidWBitRange(int wbits) {
            return wbits < -7 || wbits > 7 && wbits <= 15 || wbits > 24 && wbits <= 31;
        }

        @Specialization(guards={"method == DEFLATED", "useNative()"})
        static Object doNative(int level, int method, int wbits, int memLevel, int strategy, byte[] zdict, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached NativeLibrary.InvokeNativeFunction createCompObject, @Cached NativeLibrary.InvokeNativeFunction compressObjInit, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            NFIZlibSupport zlibSupport = PythonContext.get(inliningTarget).getNFIZlibSupport();
            Object zst = zlibSupport.createCompObject(createCompObject);
            int err = zdict.length > 0 ? zlibSupport.compressObjInitWithDict(zst, level, method, wbits, memLevel, strategy, zdict, zdict.length, compressObjInit) : zlibSupport.compressObjInit(zst, level, method, wbits, memLevel, strategy, compressObjInit);
            if (err != 0) {
                errorHandling.execute(inliningTarget, zst, err, zlibSupport, true);
            }
            return PFactory.createNativeZLibCompObjectCompress(language, zst, zlibSupport);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"method == DEFLATED", "!useNative()", "isValidWBitRange(wbits)"})
        static Object doJava(int level, int method, int wbits, int memLevel, int strategy, byte[] zdict, @Bind PythonLanguage language) {
            JavaCompress compress = PFactory.createJavaZLibCompObjectCompress(language, level, wbits, strategy, zdict);
            compress.setStrategy();
            compress.setDictionary();
            return compress;
        }

        @Specialization(guards={"method == DEFLATED", "!useNative()", "!isValidWBitRange(wbits)"})
        static Object invalid(int level, int method, int wbits, int memLevel, int strategy, byte[] zdict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_INITIALIZATION_OPTION);
        }

        @Specialization(guards={"method != DEFLATED"})
        static Object methodErr(int level, int method, int wbits, int memLevel, int strategy, byte[] zdict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.ONLY_DEFLATED_ALLOWED_AS_METHOD, 8, method);
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data", "wbits", "bufsize"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="wbits", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.MAX_WBITS", useDefaultForNone=true), @ArgumentClinic(name="bufsize", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="ZLibModuleBuiltins.DEF_BUF_SIZE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PBytes decompress(VirtualFrame frame, Object buffer, int wbits, int bufsize, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached DecompressInnerNode innerNode, @Cached PRaiseNode raiseNode) {
            try {
                if (bufsize < 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.MUST_BE_NON_NEGATIVE, "bufsize");
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                byte[] resultArray = innerNode.execute(inliningTarget, bytes, len, wbits, bufsize);
                PBytes pBytes = PFactory.createBytes(language, resultArray);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class DecompressInnerNode
        extends Node {
            DecompressInnerNode() {
            }

            abstract byte[] execute(Node var1, byte[] var2, int var3, int var4, int var5);

            @NonIdempotent
            protected boolean useNative() {
                return PythonContext.get(this).getNFIZlibSupport().isAvailable();
            }

            @Specialization(guards={"useNative()"})
            static byte[] doNative(Node inliningTarget, byte[] bytes, int length, int wbits, int bufsize, @Cached ZlibNodes.ZlibNativeDecompress nativeDecompress) {
                return nativeDecompress.execute(inliningTarget, bytes, length, wbits, bufsize, PythonContext.get(inliningTarget));
            }

            @Specialization(guards={"!useNative()"})
            @CompilerDirectives.TruffleBoundary
            static byte[] doJava(Node inliningTarget, byte[] bytes, int length, int wbits, int bufsize) {
                return JavaDecompress.decompress(bytes, length, wbits, bufsize == 0 ? 1 : bufsize, inliningTarget);
            }
        }
    }

    @Builtin(name="compress", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data", "level", "wbits"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="level", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.Z_DEFAULT_COMPRESSION", useDefaultForNone=true), @ArgumentClinic(name="wbits", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.MAX_WBITS", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CompressNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.CompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PBytes compress(VirtualFrame frame, Object buffer, int level, int wbits, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached CompressInnerNode innerNode) {
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                byte[] resultArray = innerNode.execute(inliningTarget, bytes, len, level, wbits);
                PBytes pBytes = PFactory.createBytes(language, resultArray);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CompressInnerNode
        extends Node {
            CompressInnerNode() {
            }

            abstract byte[] execute(Node var1, byte[] var2, int var3, int var4, int var5);

            @NonIdempotent
            protected boolean useNative() {
                return PythonContext.get(this).getNFIZlibSupport().isAvailable();
            }

            protected static boolean isValidLevel(int level) {
                return level >= 0 && level <= 9 || level == -1;
            }

            @Specialization(guards={"useNative()"})
            static byte[] doNative(Node inliningTarget, byte[] bytes, int length, int level, int wbits, @Cached ZlibNodes.ZlibNativeCompress nativeCompress) {
                return nativeCompress.execute(inliningTarget, bytes, length, level, wbits);
            }

            @Specialization(guards={"!useNative()", "isValidLevel(level)"})
            static byte[] doJava(byte[] bytes, int length, int level, int wbits, @Bind Node inliningTarget) {
                return JavaCompress.compressFinish(bytes, length, level, wbits, inliningTarget);
            }

            @Specialization(guards={"!useNative()", "!isValidLevel(level)"})
            static byte[] doJavaLevelError(byte[] bytes, int length, int level, int wbits, @Bind Node inliningTarget) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.BAD_COMPRESSION_LEVEL);
            }
        }
    }

    @Builtin(name="adler32", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"data", "value"})
    @ArgumentClinic(name="value", conversionClass=ExpectIntNode.class, defaultValue="PNone.NO_VALUE", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class Adler32Node
    extends PythonBinaryClinicBuiltinNode {
        private static final int DEFER = 3850;
        private static final int BASE = 65521;

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.Adler32NodeClinicProviderGen.INSTANCE;
        }

        @NonIdempotent
        protected boolean useNative() {
            return this.getContext().getNFIZlibSupport().isAvailable();
        }

        @Specialization
        long doitNone(VirtualFrame frame, Object data, PNone value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode) {
            return Adler32Node.doAdler32(toBytesNode.execute(frame, data));
        }

        @CompilerDirectives.TruffleBoundary
        private static long doAdler32(byte[] bytes) {
            Adler32 adler32 = new Adler32();
            adler32.update(bytes);
            return adler32.getValue();
        }

        @Specialization(guards={"useNative()"})
        long doNativeBytes(PBytesLike data, int value, @Bind Node inliningTarget, @Cached.Shared(value="b") @Cached SequenceStorageNodes.GetInternalBytesNode toBytes, @Cached.Shared @Cached NativeLibrary.InvokeNativeFunction invoke) {
            byte[] bytes = toBytes.execute(inliningTarget, data);
            int len = data.getSequenceStorage().length();
            return this.nativeAdler32(bytes, len, value, PythonContext.get(this), invoke);
        }

        @Specialization(guards={"useNative()", "!isBytes(data)"})
        long doNativeObject(VirtualFrame frame, Object data, int value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached NativeLibrary.InvokeNativeFunction invoke) {
            byte[] bytes = toBytesNode.execute(frame, data);
            return this.nativeAdler32(bytes, bytes.length, value, PythonContext.get(this), invoke);
        }

        @Specialization(guards={"!useNative()"})
        long doJavaBytes(PBytesLike data, int value, @Bind Node inliningTarget, @Cached.Shared(value="b") @Cached SequenceStorageNodes.GetInternalBytesNode toBytes) {
            byte[] bytes = toBytes.execute(inliningTarget, data);
            int len = data.getSequenceStorage().length();
            return this.javaAdler32(bytes, len, value);
        }

        @Specialization(guards={"!useNative()", "!isBytes(data)"})
        long doJavaObject(VirtualFrame frame, Object data, int value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bytes = toBytesNode.execute(frame, data);
            return this.javaAdler32(bytes, bytes.length, value);
        }

        long nativeAdler32(byte[] bytes, int len, int value, PythonContext ctxt, NativeLibrary.InvokeNativeFunction invoke) {
            int signedVal = (int)ctxt.getNFIZlibSupport().adler32(value, bytes, len, invoke);
            return (long)signedVal & 0xFFFFFFFFL;
        }

        long javaAdler32(byte[] bytes, int len, int value) {
            int index = 0;
            int result = value;
            int s1 = result & 0xFFFF;
            int s2 = result >>> 16;
            while (index < len) {
                int max = Math.min(index + 3850, index + len);
                while (index < max) {
                    s1 = (bytes[index++] & 0xFF) + s1;
                    s2 += s1;
                }
                s1 %= 65521;
                s2 %= 65521;
            }
            result = s2 << 16 | s1;
            return (long)result & 0xFFFFFFFFL;
        }
    }

    @Builtin(name="crc32", minNumOfPositionalArgs=1, parameterNames={"data", "value"})
    @ArgumentClinic(name="value", conversionClass=ExpectIntNode.class, defaultValue="PNone.NO_VALUE", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class Crc32Node
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZLibModuleBuiltinsClinicProviders.Crc32NodeClinicProviderGen.INSTANCE;
        }

        @NonIdempotent
        protected boolean useNative() {
            return PythonContext.get(this).getNFIZlibSupport().isAvailable();
        }

        @Specialization
        long doitNone(VirtualFrame frame, Object data, PNone value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode) {
            return Crc32Node.doCRC32(toBytesNode.execute(frame, data));
        }

        @CompilerDirectives.TruffleBoundary
        static long doCRC32(byte[] data) {
            CRC32 crc32 = new CRC32();
            crc32.update(data);
            return crc32.getValue();
        }

        @Specialization(guards={"useNative()"})
        long doNativeBytes(PBytesLike data, int value, @Bind Node inliningTarget, @Cached.Shared(value="b") @Cached SequenceStorageNodes.GetInternalBytesNode toBytes, @Cached.Shared @Cached NativeLibrary.InvokeNativeFunction invoke) {
            byte[] bytes = toBytes.execute(inliningTarget, data);
            int len = data.getSequenceStorage().length();
            return this.nativeCrc32(bytes, len, value, invoke);
        }

        @Specialization(guards={"useNative()", "!isBytes(data)"})
        long doNativeObject(VirtualFrame frame, Object data, int value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached NativeLibrary.InvokeNativeFunction invoke) {
            byte[] bytes = toBytesNode.execute(frame, data);
            return this.nativeCrc32(bytes, bytes.length, value, invoke);
        }

        @Specialization(guards={"!useNative()"})
        static long doJavaBytes(PBytesLike data, int value, @Bind Node inliningTarget, @Cached.Shared(value="b") @Cached SequenceStorageNodes.GetInternalBytesNode toBytes) {
            byte[] bytes = toBytes.execute(inliningTarget, data);
            int len = data.getSequenceStorage().length();
            return PythonUtils.crc32(value, bytes, 0, len);
        }

        @Specialization(guards={"!useNative()", "!isBytes(data)"})
        static long doJavaObject(VirtualFrame frame, Object data, int value, @Cached.Shared(value="bb") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bytes = toBytesNode.execute(frame, data);
            return PythonUtils.crc32(value, bytes, 0, bytes.length);
        }

        @Fallback
        static long error(Object data, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_BYTESLIKE_GOT_P, data);
        }

        long nativeCrc32(byte[] bytes, int len, int value, NativeLibrary.InvokeNativeFunction invoke) {
            PythonContext ctxt = this.getContext();
            int signedVal = (int)ctxt.getNFIZlibSupport().crc32(value, bytes, len, invoke);
            return (long)signedVal & 0xFFFFFFFFL;
        }
    }

    public static abstract class ExpectByteLikeNode
    extends ArgumentCastNode {
        private final byte[] defaultValue;

        protected ExpectByteLikeNode(byte[] defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization
        byte[] handleNone(PNone none) {
            return this.defaultValue;
        }

        @Specialization
        static byte[] doBytes(PBytesLike bytesLike, @Cached.Shared(value="b") @Cached BytesNodes.ToBytesNode toBytesNode) {
            return toBytesNode.execute(bytesLike);
        }

        @Specialization
        static byte[] doMemView(VirtualFrame frame, PMemoryView bytesLike, @Cached.Shared(value="b") @Cached BytesNodes.ToBytesNode toBytesNode) {
            return toBytesNode.execute(frame, bytesLike);
        }

        @Fallback
        static byte[] error(VirtualFrame frame, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, value);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectByteLikeNode create(@ClinicConverterFactory.DefaultValue byte[] defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
            assert (useDefaultForNone);
            return ZLibModuleBuiltinsFactory.ExpectByteLikeNodeGen.create(defaultValue);
        }
    }

    @ImportStatic(value={MathGuards.class})
    public static abstract class ExpectIntNode
    extends ArgumentCastNode {
        private final Object defaultValue;

        protected ExpectIntNode(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization
        Object none(PNone none) {
            return this.defaultValue;
        }

        @Specialization
        static int doInt(int i) {
            return i;
        }

        @Specialization
        static int doBool(boolean b) {
            return PInt.intValue(b);
        }

        @Specialization
        public int toInt(long x) {
            return (int)x;
        }

        @Specialization
        public int toInt(PInt x) {
            return x.intValue();
        }

        @Specialization(guards={"!isPNone(value)", "!isInteger(value)"})
        static Object doOthers(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyLongAsIntNode asIntNode) {
            return asIntNode.execute((Frame)frame, inliningTarget, value);
        }

        protected ExpectIntNode createRec() {
            return ZLibModuleBuiltinsFactory.ExpectIntNodeGen.create(this.defaultValue);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectIntNode create(@ClinicConverterFactory.DefaultValue Object defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
            assert (useDefaultForNone);
            return ZLibModuleBuiltinsFactory.ExpectIntNodeGen.create(defaultValue);
        }
    }
}

