/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

public class AzureIdpHostUtil {
    public static final String MICROSOFT_COMMERCIAL_HOST = "login.microsoftonline.com";
    public static final String MICROSOFT_US_GOV_HOST = "login.microsoftonline.us";
    public static final String MICROSOFT_CHINA_HOST = "login.chinacloudapi.cn";

    private AzureIdpHostUtil() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static String getIdpHostByPartition(String partition) throws IllegalArgumentException {
        String trimmedPartition;
        if (partition == null || partition.trim().isEmpty()) {
            return MICROSOFT_COMMERCIAL_HOST;
        }
        switch (trimmedPartition = partition.trim().toLowerCase()) {
            case "commercial": {
                return MICROSOFT_COMMERCIAL_HOST;
            }
            case "us-gov": {
                return MICROSOFT_US_GOV_HOST;
            }
            case "cn": {
                return MICROSOFT_CHINA_HOST;
            }
        }
        throw new IllegalArgumentException("Invalid idp_partition value. Supported values are: null/empty, 'commercial', 'us-gov', 'cn'");
    }

    public static void validatePartition(String partition) throws IllegalArgumentException {
        try {
            AzureIdpHostUtil.getIdpHostByPartition(partition);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid idp_partition value. Supported values are: null/empty, 'commercial', 'us-gov', 'cn'");
        }
    }
}

