/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.carrot2.language.LanguageComponents;

public class LoadedLanguages {
    private final Map<String, Map<Class<?>, Supplier<?>>> preloadedSuppliers;

    LoadedLanguages(Map<String, Map<Class<?>, Supplier<?>>> preloadedSuppliers) {
        this.preloadedSuppliers = preloadedSuppliers;
    }

    public LanguageComponents language(String language) {
        if (!this.preloadedSuppliers.containsKey(language)) {
            throw new RuntimeException(String.format(Locale.ROOT, "Language components not available for language: %s [available: %s]", language, String.join((CharSequence)", ", this.languages())));
        }
        return new LanguageComponents(language, this.preloadedSuppliers.get(language));
    }

    public Set<String> languages() {
        return this.preloadedSuppliers.keySet();
    }
}

