//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_PURPOSE_SCHEMA_H
#define PXR_IMAGING_HD_PURPOSE_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PURPOSE_SCHEMA_TOKENS \
    (purpose) \
    (inheritable) \
    (fallback) \

TF_DECLARE_PUBLIC_TOKENS(HdPurposeSchemaTokens, HD_API,
    HD_PURPOSE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdPurposeSchema
///
class HdPurposeSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPurposeSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "purpose" from the parent container and constructs a
    /// HdPurposeSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdPurposeSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--

    /// Resolve purpose to a TfToken value.
    /// This applies the fallback value as needed, and ultimately
    /// uses "geometry" if no other value is provided.
    HD_API
    TfToken ResolvePurposeValue();

// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdTokenDataSourceHandle GetPurpose() const;

    /// The "inheritable" flag indicates if this purpose schema should be
    /// inherited by the HdFlattenedPurposeDataSourceProvider.
    HD_API
    HdBoolDataSourceHandle GetInheritable() const;

    /// The "purpose" concept in Hydra is modelled after the UsdGeomImageable
    /// concept, which allows prim types to define a purpose fallback value to
    /// be used when no purpose value is found on a prim or its ancestors. The
    /// Hydra schema transports this fallback, if present, to apply it during
    /// flattening.
    HD_API
    HdTokenDataSourceHandle GetFallback() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &purpose,
        const HdBoolDataSourceHandle &inheritable,
        const HdTokenDataSourceHandle &fallback
    );

    /// \class HdPurposeSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetPurpose(
            const HdTokenDataSourceHandle &purpose);
        HD_API
        Builder &SetInheritable(
            const HdBoolDataSourceHandle &inheritable);
        HD_API
        Builder &SetFallback(
            const HdTokenDataSourceHandle &fallback);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _purpose;
        HdBoolDataSourceHandle _inheritable;
        HdTokenDataSourceHandle _fallback;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif