import type { Struct, ZclArray } from "zigbee-herdsman/dist/zspec/zcl/definition/tstype";
import { type BinaryArgs, type NumericArgs } from "./modernExtend";
import type { ModernExtend, Zh } from "./types";
interface UbisysHvacThermostat {
    attributes: {
        ubisysClassBTemperatureOffset: number;
        ubisysReturnFlowTemperatureWeight: number;
        ubisysRawOutdoorTemperature: Struct;
        ubisysRawLocalTemperatureA: Struct;
        ubisysRawLocalTemperatureB: Struct;
        ubisysRawForwardFlowTemperature: Struct;
        ubisysRawReturnFlowTemperature: Struct;
        ubisysInstalledExtensions: bigint;
        ubisysTemperatureOffset: number;
        ubisysDefaultOccupiedHeatingSetpoint: number;
        ubisysVacationMode: number;
        ubisysRemoteTemperature: number;
        ubisysRemoteTemperatureValidDuration: number;
        ubisysDetectOpenWindow: number;
        ubisysOpenWindowState: number;
        ubisysOpenWindowSensitivity: number;
        ubisysOpenWindowDetectionPeriod: number;
        ubisysOpenWindowTimeout: number;
        ubisysProportionalGain: number;
        ubisysProportionalShift: number;
        ubisysIntegralFactor: number;
    };
    commands: never;
    commandResponses: never;
}
export interface UbisysGenLevelCtrl {
    attributes: {
        ubisysMinimumOnLevel: number;
        ubisysValveType: number;
        ubisysCyclePeriod: number;
        ubisysSeason: number;
        ubisysBackupLevel: number;
        ubisysAlternateBackupLevel: number;
        ubisysLowerRange: number;
        ubisysUpperRange: number;
        ubisysPumpThresholdOn: number;
        ubisysPumpThresholdOff: number;
        ubisysHeatingDemandEnableThreshold: number;
        ubisysHeatingDemandDisableThreshold: number;
        ubisysCoolingDemandEnableThreshold: number;
        ubisysCoolingDemandDisableThreshold: number;
    };
    commands: never;
    commandResponses: never;
}
export interface UbisysClosuresWindowCovering {
    attributes: {
        ubisysTurnaroundGuardTime: number;
        ubisysLiftToTiltTransitionSteps: number;
        ubisysTotalSteps: number;
        ubisysLiftToTiltTransitionSteps2: number;
        ubisysTotalSteps2: number;
        ubisysAdditionalSteps: number;
        ubisysInactivePowerThreshold: number;
        ubisysStartupSteps: number;
    };
    commands: never;
    commandResponses: never;
}
export interface UbisysDeviceSetup {
    attributes: {
        inputConfigurations: ZclArray | unknown[];
        inputActions: ZclArray | unknown[];
    };
    commands: never;
    commandResponses: never;
}
export interface UbisysDimmerSetup {
    attributes: {
        capabilities: number;
        status: number;
        mode: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const ubisysModernExtend: {
    pollCurrentSummDelivered: (endpointId: number | ((device: Zh.Device) => number)) => ModernExtend;
    addCustomClusterHvacThermostat: () => ModernExtend;
    addCustomClusterGenLevelCtrl: () => ModernExtend;
    addCustomClusterClosuresWindowCovering: () => ModernExtend;
    addCustomClusterManuSpecificUbisysDeviceSetup: () => ModernExtend;
    addCustomClusterManuSpecificUbisysDimmerSetup: () => ModernExtend;
    localTemperatureOffset: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    occupiedHeatingSetpointDefault: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    remoteTemperatureDuration: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    vacationMode: () => ModernExtend;
    openWindowState: (args?: Partial<BinaryArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    openWindowDetect: (args?: Partial<BinaryArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    openWindowTimeout: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    openWindowDetectionPeriod: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
    openWindowSensitivity: (args?: Partial<NumericArgs<"hvacThermostat", UbisysHvacThermostat>>) => ModernExtend;
};
export {};
//# sourceMappingURL=ubisys.d.ts.map