/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SchemeBorder
extends AbstractBorder
implements ColorConstants {
    protected Scheme scheme = null;
    protected static final Color[] DARKEST_DARKER = new Color[]{buttonDarkest, buttonDarker};
    protected static final Color[] LIGHTER_DARKER = new Color[]{buttonLightest, buttonDarker};
    protected static final Color[] DARKER_LIGHTER = new Color[]{buttonDarker, buttonLightest};

    protected SchemeBorder() {
    }

    public SchemeBorder(Scheme scheme) {
        this.setScheme(scheme);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return this.getScheme().getInsets();
    }

    protected Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    protected void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        Color[] tl = this.scheme.getHighlight();
        Color[] br = this.scheme.getShadow();
        this.paint(g, figure, insets, tl, br);
    }

    protected void paint(Graphics graphics, IFigure fig, Insets insets, Color[] tl, Color[] br) {
        Color color;
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        graphics.setXORMode(false);
        Rectangle rect = SchemeBorder.getPaintRectangle(fig, insets);
        int top = rect.y;
        int left = rect.x;
        int bottom = rect.bottom() - 1;
        int right = rect.right() - 1;
        int i = 0;
        while (i < br.length) {
            color = br[i];
            graphics.setForegroundColor(color);
            graphics.drawLine(right - i, bottom - i, right - i, top + i);
            graphics.drawLine(right - i, bottom - i, left + i, bottom - i);
            ++i;
        }
        --right;
        --bottom;
        i = 0;
        while (i < tl.length) {
            color = tl[i];
            graphics.setForegroundColor(color);
            graphics.drawLine(left + i, top + i, right - i, top + i);
            graphics.drawLine(left + i, top + i, left + i, bottom - i);
            ++i;
        }
    }

    public static interface SCHEMES {
        public static final Scheme BUTTON_CONTRAST = new Scheme(new Color[]{button, buttonLightest}, DARKEST_DARKER);
        public static final Scheme BUTTON_RAISED = new Scheme(new Color[]{buttonLightest}, DARKEST_DARKER);
        public static final Scheme BUTTON_PRESSED = new Scheme(DARKEST_DARKER, new Color[]{buttonLightest});
        public static final Scheme RAISED = new Scheme(new Color[]{buttonLightest}, new Color[]{buttonDarkest});
        public static final Scheme LOWERED = new Scheme(new Color[]{buttonDarkest}, new Color[]{buttonLightest});
        public static final Scheme RIDGED = new Scheme(LIGHTER_DARKER, DARKER_LIGHTER);
        public static final Scheme ETCHED = new Scheme(DARKER_LIGHTER, LIGHTER_DARKER);
    }

    public static class Scheme {
        private Insets insets;
        private boolean isOpaque = false;
        protected Color[] highlight;
        protected Color[] shadow;

        protected Scheme() {
        }

        public Scheme(Color[] highlight, Color[] shadow) {
            this.highlight = highlight;
            this.shadow = shadow;
            this.init();
        }

        public Scheme(Color[] colors) {
            this.shadow = colors;
            this.highlight = colors;
            this.init();
        }

        protected Insets calculateInsets() {
            int tl = this.getHighlight().length;
            int br = this.getShadow().length;
            return new Insets(tl, tl, br, br);
        }

        protected boolean calculateOpaque() {
            Color color;
            Color[] colors;
            Color[] colorArray = colors = this.getHighlight();
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                color = colorArray[n2];
                if (color == null) {
                    return false;
                }
                ++n2;
            }
            colorArray = colors = this.getShadow();
            n = colors.length;
            n2 = 0;
            while (n2 < n) {
                color = colorArray[n2];
                if (color == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected Color[] getHighlight() {
            return this.highlight;
        }

        protected Insets getInsets() {
            return this.insets;
        }

        protected Color[] getShadow() {
            return this.shadow;
        }

        protected void init() {
            this.insets = this.calculateInsets();
            this.isOpaque = this.calculateOpaque();
        }

        protected boolean isOpaque() {
            return this.isOpaque;
        }
    }
}

